package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Blob, Qualifier, NamespacedFunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InvokeWithResponseStreamRequest(
    functionName: NamespacedFunctionName,
    invocationType: Optional[
      zio.aws.lambda.model.ResponseStreamingInvocationType
    ] = Optional.Absent,
    logType: Optional[zio.aws.lambda.model.LogType] = Optional.Absent,
    clientContext: Optional[String] = Optional.Absent,
    qualifier: Optional[Qualifier] = Optional.Absent,
    payload: Optional[Blob] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamRequest = {
    import InvokeWithResponseStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamRequest
      .builder()
      .functionName(
        NamespacedFunctionName.unwrap(functionName): java.lang.String
      )
      .optionallyWith(invocationType.map(value => value.unwrap))(
        _.invocationType
      )
      .optionallyWith(logType.map(value => value.unwrap))(_.logType)
      .optionallyWith(clientContext.map(value => value: java.lang.String))(
        _.clientContext
      )
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .optionallyWith(
        payload.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.payload)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.InvokeWithResponseStreamRequest.ReadOnly =
    zio.aws.lambda.model.InvokeWithResponseStreamRequest.wrap(buildAwsValue())
}
object InvokeWithResponseStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.InvokeWithResponseStreamRequest =
      zio.aws.lambda.model.InvokeWithResponseStreamRequest(
        functionName,
        invocationType.map(value => value),
        logType.map(value => value),
        clientContext.map(value => value),
        qualifier.map(value => value),
        payload.map(value => value)
      )
    def functionName: NamespacedFunctionName
    def invocationType
        : Optional[zio.aws.lambda.model.ResponseStreamingInvocationType]
    def logType: Optional[zio.aws.lambda.model.LogType]
    def clientContext: Optional[String]
    def qualifier: Optional[Qualifier]
    def payload: Optional[Blob]
    def getFunctionName: ZIO[Any, Nothing, NamespacedFunctionName] =
      ZIO.succeed(functionName)
    def getInvocationType: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.ResponseStreamingInvocationType
    ] = AwsError.unwrapOptionField("invocationType", invocationType)
    def getLogType: ZIO[Any, AwsError, zio.aws.lambda.model.LogType] =
      AwsError.unwrapOptionField("logType", logType)
    def getClientContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientContext", clientContext)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
    def getPayload: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("payload", payload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamRequest
  ) extends zio.aws.lambda.model.InvokeWithResponseStreamRequest.ReadOnly {
    override val functionName: NamespacedFunctionName =
      zio.aws.lambda.model.primitives
        .NamespacedFunctionName(impl.functionName())
    override val invocationType
        : Optional[zio.aws.lambda.model.ResponseStreamingInvocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationType())
        .map(value =>
          zio.aws.lambda.model.ResponseStreamingInvocationType.wrap(value)
        )
    override val logType: Optional[zio.aws.lambda.model.LogType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logType())
        .map(value => zio.aws.lambda.model.LogType.wrap(value))
    override val clientContext: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientContext())
      .map(value => value: String)
    override val qualifier: Optional[Qualifier] = zio.aws.core.internal
      .optionalFromNullable(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
    override val payload: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.payload())
      .map(value =>
        zio.aws.lambda.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamRequest
  ): zio.aws.lambda.model.InvokeWithResponseStreamRequest.ReadOnly =
    new Wrapper(impl)
}
