package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{FunctionUrlQualifier, FunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFunctionUrlConfigRequest(
    functionName: FunctionName,
    qualifier: Optional[FunctionUrlQualifier] = Optional.Absent,
    authType: zio.aws.lambda.model.FunctionUrlAuthType,
    cors: Optional[zio.aws.lambda.model.Cors] = Optional.Absent,
    invokeMode: Optional[zio.aws.lambda.model.InvokeMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigRequest = {
    import CreateFunctionUrlConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        qualifier.map(value =>
          FunctionUrlQualifier.unwrap(value): java.lang.String
        )
      )(_.qualifier)
      .authType(authType.unwrap)
      .optionallyWith(cors.map(value => value.buildAwsValue()))(_.cors)
      .optionallyWith(invokeMode.map(value => value.unwrap))(_.invokeMode)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.CreateFunctionUrlConfigRequest.ReadOnly =
    zio.aws.lambda.model.CreateFunctionUrlConfigRequest.wrap(buildAwsValue())
}
object CreateFunctionUrlConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CreateFunctionUrlConfigRequest =
      zio.aws.lambda.model.CreateFunctionUrlConfigRequest(
        functionName,
        qualifier.map(value => value),
        authType,
        cors.map(value => value.asEditable),
        invokeMode.map(value => value)
      )
    def functionName: FunctionName
    def qualifier: Optional[FunctionUrlQualifier]
    def authType: zio.aws.lambda.model.FunctionUrlAuthType
    def cors: Optional[zio.aws.lambda.model.Cors.ReadOnly]
    def invokeMode: Optional[zio.aws.lambda.model.InvokeMode]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, FunctionUrlQualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
    def getAuthType
        : ZIO[Any, Nothing, zio.aws.lambda.model.FunctionUrlAuthType] =
      ZIO.succeed(authType)
    def getCors: ZIO[Any, AwsError, zio.aws.lambda.model.Cors.ReadOnly] =
      AwsError.unwrapOptionField("cors", cors)
    def getInvokeMode: ZIO[Any, AwsError, zio.aws.lambda.model.InvokeMode] =
      AwsError.unwrapOptionField("invokeMode", invokeMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigRequest
  ) extends zio.aws.lambda.model.CreateFunctionUrlConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Optional[FunctionUrlQualifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualifier())
        .map(value =>
          zio.aws.lambda.model.primitives.FunctionUrlQualifier(value)
        )
    override val authType: zio.aws.lambda.model.FunctionUrlAuthType =
      zio.aws.lambda.model.FunctionUrlAuthType.wrap(impl.authType())
    override val cors: Optional[zio.aws.lambda.model.Cors.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cors())
        .map(value => zio.aws.lambda.model.Cors.wrap(value))
    override val invokeMode: Optional[zio.aws.lambda.model.InvokeMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invokeMode())
        .map(value => zio.aws.lambda.model.InvokeMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigRequest
  ): zio.aws.lambda.model.CreateFunctionUrlConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
