package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SnapStart(
    applyOn: Optional[zio.aws.lambda.model.SnapStartApplyOn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.SnapStart = {
    import SnapStart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.SnapStart
      .builder()
      .optionallyWith(applyOn.map(value => value.unwrap))(_.applyOn)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.SnapStart.ReadOnly =
    zio.aws.lambda.model.SnapStart.wrap(buildAwsValue())
}
object SnapStart {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lambda.model.SnapStart] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.SnapStart =
      zio.aws.lambda.model.SnapStart(applyOn.map(value => value))
    def applyOn: Optional[zio.aws.lambda.model.SnapStartApplyOn]
    def getApplyOn: ZIO[Any, AwsError, zio.aws.lambda.model.SnapStartApplyOn] =
      AwsError.unwrapOptionField("applyOn", applyOn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.SnapStart
  ) extends zio.aws.lambda.model.SnapStart.ReadOnly {
    override val applyOn: Optional[zio.aws.lambda.model.SnapStartApplyOn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applyOn())
        .map(value => zio.aws.lambda.model.SnapStartApplyOn.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.SnapStart
  ): zio.aws.lambda.model.SnapStart.ReadOnly = new Wrapper(impl)
}
