package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{S3ObjectVersion, S3Key, S3Bucket, Blob}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FunctionCode(
    zipFile: Optional[Blob] = Optional.Absent,
    s3Bucket: Optional[S3Bucket] = Optional.Absent,
    s3Key: Optional[S3Key] = Optional.Absent,
    s3ObjectVersion: Optional[S3ObjectVersion] = Optional.Absent,
    imageUri: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.FunctionCode = {
    import FunctionCode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.FunctionCode
      .builder()
      .optionallyWith(
        zipFile.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.zipFile)
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(
        s3ObjectVersion.map(value =>
          S3ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.s3ObjectVersion)
      .optionallyWith(imageUri.map(value => value: java.lang.String))(
        _.imageUri
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.FunctionCode.ReadOnly =
    zio.aws.lambda.model.FunctionCode.wrap(buildAwsValue())
}
object FunctionCode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.FunctionCode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.FunctionCode =
      zio.aws.lambda.model.FunctionCode(
        zipFile.map(value => value),
        s3Bucket.map(value => value),
        s3Key.map(value => value),
        s3ObjectVersion.map(value => value),
        imageUri.map(value => value)
      )
    def zipFile: Optional[Blob]
    def s3Bucket: Optional[S3Bucket]
    def s3Key: Optional[S3Key]
    def s3ObjectVersion: Optional[S3ObjectVersion]
    def imageUri: Optional[String]
    def getZipFile: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("zipFile", zipFile)
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getS3ObjectVersion: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField("s3ObjectVersion", s3ObjectVersion)
    def getImageUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageUri", imageUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.FunctionCode
  ) extends zio.aws.lambda.model.FunctionCode.ReadOnly {
    override val zipFile: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.zipFile())
      .map(value =>
        zio.aws.lambda.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val s3Bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.lambda.model.primitives.S3Bucket(value))
    override val s3Key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => zio.aws.lambda.model.primitives.S3Key(value))
    override val s3ObjectVersion: Optional[S3ObjectVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3ObjectVersion())
        .map(value => zio.aws.lambda.model.primitives.S3ObjectVersion(value))
    override val imageUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageUri())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.FunctionCode
  ): zio.aws.lambda.model.FunctionCode.ReadOnly = new Wrapper(impl)
}
