package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait StateReasonCode {
  def unwrap: software.amazon.awssdk.services.lambda.model.StateReasonCode
}
object StateReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.StateReasonCode
  ): zio.aws.lambda.model.StateReasonCode = value match {
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.IDLE =>
      val r = Idle
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.RESTORING =>
      val r = Restoring
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.ENI_LIMIT_EXCEEDED =>
      val r = EniLimitExceeded
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.INSUFFICIENT_ROLE_PERMISSIONS =>
      val r = InsufficientRolePermissions
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_CONFIGURATION =>
      val r = InvalidConfiguration
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.INTERNAL_ERROR =>
      val r = InternalError
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.SUBNET_OUT_OF_IP_ADDRESSES =>
      val r = SubnetOutOfIPAddresses
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_SUBNET =>
      val r = InvalidSubnet
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_SECURITY_GROUP =>
      val r = InvalidSecurityGroup
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.IMAGE_DELETED =>
      val r = ImageDeleted
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.IMAGE_ACCESS_DENIED =>
      val r = ImageAccessDenied
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_IMAGE =>
      val r = InvalidImage
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.KMS_KEY_ACCESS_DENIED =>
      val r = KMSKeyAccessDenied
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.KMS_KEY_NOT_FOUND =>
      val r = KMSKeyNotFound
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_STATE_KMS_KEY =>
      val r = InvalidStateKMSKey
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.DISABLED_KMS_KEY =>
      val r = DisabledKMSKey
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.EFSIO_ERROR =>
      val r = EFSIOError
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.EFS_MOUNT_CONNECTIVITY_ERROR =>
      val r = EFSMountConnectivityError
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.EFS_MOUNT_FAILURE =>
      val r = EFSMountFailure
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.EFS_MOUNT_TIMEOUT =>
      val r = EFSMountTimeout
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_RUNTIME =>
      val r = InvalidRuntime
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_ZIP_FILE_EXCEPTION =>
      val r = InvalidZipFileException
      r
    case software.amazon.awssdk.services.lambda.model.StateReasonCode.FUNCTION_ERROR =>
      val r = FunctionError
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object Idle extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.IDLE
  }
  case object Creating extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.CREATING
  }
  case object Restoring extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.RESTORING
  }
  case object EniLimitExceeded extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.ENI_LIMIT_EXCEEDED
  }
  case object InsufficientRolePermissions
      extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.INSUFFICIENT_ROLE_PERMISSIONS
  }
  case object InvalidConfiguration
      extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_CONFIGURATION
  }
  case object InternalError extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.INTERNAL_ERROR
  }
  case object SubnetOutOfIPAddresses
      extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.SUBNET_OUT_OF_IP_ADDRESSES
  }
  case object InvalidSubnet extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_SUBNET
  }
  case object InvalidSecurityGroup
      extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_SECURITY_GROUP
  }
  case object ImageDeleted extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.IMAGE_DELETED
  }
  case object ImageAccessDenied extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.IMAGE_ACCESS_DENIED
  }
  case object InvalidImage extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_IMAGE
  }
  case object KMSKeyAccessDenied extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.KMS_KEY_ACCESS_DENIED
  }
  case object KMSKeyNotFound extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.KMS_KEY_NOT_FOUND
  }
  case object InvalidStateKMSKey extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_STATE_KMS_KEY
  }
  case object DisabledKMSKey extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.DISABLED_KMS_KEY
  }
  case object EFSIOError extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.EFSIO_ERROR
  }
  case object EFSMountConnectivityError
      extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.EFS_MOUNT_CONNECTIVITY_ERROR
  }
  case object EFSMountFailure extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.EFS_MOUNT_FAILURE
  }
  case object EFSMountTimeout extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.EFS_MOUNT_TIMEOUT
  }
  case object InvalidRuntime extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_RUNTIME
  }
  case object InvalidZipFileException
      extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.INVALID_ZIP_FILE_EXCEPTION
  }
  case object FunctionError extends zio.aws.lambda.model.StateReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.StateReasonCode =
      software.amazon.awssdk.services.lambda.model.StateReasonCode.FUNCTION_ERROR
  }
}
