package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.FunctionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFunctionsByCodeSigningConfigResponse(
    nextMarker: Optional[String] = Optional.Absent,
    functionArns: Optional[Iterable[FunctionArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse = {
    import ListFunctionsByCodeSigningConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        functionArns.map(value =>
          value.map { item =>
            FunctionArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.functionArns)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse.ReadOnly =
    zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse
      .wrap(buildAwsValue())
}
object ListFunctionsByCodeSigningConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse =
      zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse(
        nextMarker.map(value => value),
        functionArns.map(value => value)
      )
    def nextMarker: Optional[String]
    def functionArns: Optional[List[FunctionArn]]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getFunctionArns: ZIO[Any, AwsError, List[FunctionArn]] =
      AwsError.unwrapOptionField("functionArns", functionArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse
  ) extends zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse.ReadOnly {
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
    override val functionArns: Optional[List[FunctionArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.primitives.FunctionArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse
  ): zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse.ReadOnly =
    new Wrapper(impl)
}
