package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.CodeSigningConfigArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCodeSigningConfigRequest(
    codeSigningConfigArn: CodeSigningConfigArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest = {
    import GetCodeSigningConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest
      .builder()
      .codeSigningConfigArn(
        CodeSigningConfigArn.unwrap(codeSigningConfigArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetCodeSigningConfigRequest.ReadOnly =
    zio.aws.lambda.model.GetCodeSigningConfigRequest.wrap(buildAwsValue())
}
object GetCodeSigningConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetCodeSigningConfigRequest =
      zio.aws.lambda.model.GetCodeSigningConfigRequest(codeSigningConfigArn)
    def codeSigningConfigArn: CodeSigningConfigArn
    def getCodeSigningConfigArn: ZIO[Any, Nothing, CodeSigningConfigArn] =
      ZIO.succeed(codeSigningConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest
  ) extends zio.aws.lambda.model.GetCodeSigningConfigRequest.ReadOnly {
    override val codeSigningConfigArn: CodeSigningConfigArn =
      zio.aws.lambda.model.primitives
        .CodeSigningConfigArn(impl.codeSigningConfigArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest
  ): zio.aws.lambda.model.GetCodeSigningConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
