package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.URI
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AmazonManagedKafkaEventSourceConfig(
    consumerGroupId: Optional[URI] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.AmazonManagedKafkaEventSourceConfig = {
    import AmazonManagedKafkaEventSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.AmazonManagedKafkaEventSourceConfig
      .builder()
      .optionallyWith(
        consumerGroupId.map(value => URI.unwrap(value): java.lang.String)
      )(_.consumerGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.AmazonManagedKafkaEventSourceConfig.ReadOnly =
    zio.aws.lambda.model.AmazonManagedKafkaEventSourceConfig
      .wrap(buildAwsValue())
}
object AmazonManagedKafkaEventSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.AmazonManagedKafkaEventSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.AmazonManagedKafkaEventSourceConfig =
      zio.aws.lambda.model.AmazonManagedKafkaEventSourceConfig(
        consumerGroupId.map(value => value)
      )
    def consumerGroupId: Optional[URI]
    def getConsumerGroupId: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("consumerGroupId", consumerGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.AmazonManagedKafkaEventSourceConfig
  ) extends zio.aws.lambda.model.AmazonManagedKafkaEventSourceConfig.ReadOnly {
    override val consumerGroupId: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerGroupId())
      .map(value => zio.aws.lambda.model.primitives.URI(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.AmazonManagedKafkaEventSourceConfig
  ): zio.aws.lambda.model.AmazonManagedKafkaEventSourceConfig.ReadOnly =
    new Wrapper(impl)
}
