package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListCodeSigningConfigsResponse(
    nextMarker: Optional[String] = Optional.Absent,
    codeSigningConfigs: Optional[
      Iterable[zio.aws.lambda.model.CodeSigningConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse = {
    import ListCodeSigningConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        codeSigningConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.codeSigningConfigs)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListCodeSigningConfigsResponse.ReadOnly =
    zio.aws.lambda.model.ListCodeSigningConfigsResponse.wrap(buildAwsValue())
}
object ListCodeSigningConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListCodeSigningConfigsResponse =
      zio.aws.lambda.model.ListCodeSigningConfigsResponse(
        nextMarker.map(value => value),
        codeSigningConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[String]
    def codeSigningConfigs
        : Optional[List[zio.aws.lambda.model.CodeSigningConfig.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getCodeSigningConfigs: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.CodeSigningConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("codeSigningConfigs", codeSigningConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse
  ) extends zio.aws.lambda.model.ListCodeSigningConfigsResponse.ReadOnly {
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
    override val codeSigningConfigs
        : Optional[List[zio.aws.lambda.model.CodeSigningConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeSigningConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.CodeSigningConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse
  ): zio.aws.lambda.model.ListCodeSigningConfigsResponse.ReadOnly = new Wrapper(
    impl
  )
}
