package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImageConfigResponse(
    imageConfig: Optional[zio.aws.lambda.model.ImageConfig] = Optional.Absent,
    error: Optional[zio.aws.lambda.model.ImageConfigError] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ImageConfigResponse = {
    import ImageConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ImageConfigResponse
      .builder()
      .optionallyWith(imageConfig.map(value => value.buildAwsValue()))(
        _.imageConfig
      )
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ImageConfigResponse.ReadOnly =
    zio.aws.lambda.model.ImageConfigResponse.wrap(buildAwsValue())
}
object ImageConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ImageConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ImageConfigResponse =
      zio.aws.lambda.model.ImageConfigResponse(
        imageConfig.map(value => value.asEditable),
        error.map(value => value.asEditable)
      )
    def imageConfig: Optional[zio.aws.lambda.model.ImageConfig.ReadOnly]
    def error: Optional[zio.aws.lambda.model.ImageConfigError.ReadOnly]
    def getImageConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.ImageConfig.ReadOnly] =
      AwsError.unwrapOptionField("imageConfig", imageConfig)
    def getError
        : ZIO[Any, AwsError, zio.aws.lambda.model.ImageConfigError.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ImageConfigResponse
  ) extends zio.aws.lambda.model.ImageConfigResponse.ReadOnly {
    override val imageConfig
        : Optional[zio.aws.lambda.model.ImageConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageConfig())
        .map(value => zio.aws.lambda.model.ImageConfig.wrap(value))
    override val error
        : Optional[zio.aws.lambda.model.ImageConfigError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.lambda.model.ImageConfigError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ImageConfigResponse
  ): zio.aws.lambda.model.ImageConfigResponse.ReadOnly = new Wrapper(impl)
}
