package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCodeSigningConfigResponse(
    codeSigningConfig: zio.aws.lambda.model.CodeSigningConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigResponse = {
    import GetCodeSigningConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigResponse
      .builder()
      .codeSigningConfig(codeSigningConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetCodeSigningConfigResponse.ReadOnly =
    zio.aws.lambda.model.GetCodeSigningConfigResponse.wrap(buildAwsValue())
}
object GetCodeSigningConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetCodeSigningConfigResponse =
      zio.aws.lambda.model
        .GetCodeSigningConfigResponse(codeSigningConfig.asEditable)
    def codeSigningConfig: zio.aws.lambda.model.CodeSigningConfig.ReadOnly
    def getCodeSigningConfig
        : ZIO[Any, Nothing, zio.aws.lambda.model.CodeSigningConfig.ReadOnly] =
      ZIO.succeed(codeSigningConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigResponse
  ) extends zio.aws.lambda.model.GetCodeSigningConfigResponse.ReadOnly {
    override val codeSigningConfig
        : zio.aws.lambda.model.CodeSigningConfig.ReadOnly =
      zio.aws.lambda.model.CodeSigningConfig.wrap(impl.codeSigningConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigResponse
  ): zio.aws.lambda.model.GetCodeSigningConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
