package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  Timeout,
  RoleArn,
  StateReason,
  NameSpacedFunctionArn,
  KMSKeyArn,
  Timestamp,
  MemorySize,
  NamespacedFunctionName,
  Arn,
  Description,
  Version,
  FunctionArn,
  LastUpdateStatusReason,
  Handler
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PublishVersionResponse(
    functionName: Optional[NamespacedFunctionName] = Optional.Absent,
    functionArn: Optional[NameSpacedFunctionArn] = Optional.Absent,
    runtime: Optional[zio.aws.lambda.model.Runtime] = Optional.Absent,
    role: Optional[RoleArn] = Optional.Absent,
    handler: Optional[Handler] = Optional.Absent,
    codeSize: Optional[Long] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    timeout: Optional[Timeout] = Optional.Absent,
    memorySize: Optional[MemorySize] = Optional.Absent,
    lastModified: Optional[Timestamp] = Optional.Absent,
    codeSha256: Optional[String] = Optional.Absent,
    version: Optional[Version] = Optional.Absent,
    vpcConfig: Optional[zio.aws.lambda.model.VpcConfigResponse] =
      Optional.Absent,
    deadLetterConfig: Optional[zio.aws.lambda.model.DeadLetterConfig] =
      Optional.Absent,
    environment: Optional[zio.aws.lambda.model.EnvironmentResponse] =
      Optional.Absent,
    kmsKeyArn: Optional[KMSKeyArn] = Optional.Absent,
    tracingConfig: Optional[zio.aws.lambda.model.TracingConfigResponse] =
      Optional.Absent,
    masterArn: Optional[FunctionArn] = Optional.Absent,
    revisionId: Optional[String] = Optional.Absent,
    layers: Optional[Iterable[zio.aws.lambda.model.Layer]] = Optional.Absent,
    state: Optional[zio.aws.lambda.model.State] = Optional.Absent,
    stateReason: Optional[StateReason] = Optional.Absent,
    stateReasonCode: Optional[zio.aws.lambda.model.StateReasonCode] =
      Optional.Absent,
    lastUpdateStatus: Optional[zio.aws.lambda.model.LastUpdateStatus] =
      Optional.Absent,
    lastUpdateStatusReason: Optional[LastUpdateStatusReason] = Optional.Absent,
    lastUpdateStatusReasonCode: Optional[
      zio.aws.lambda.model.LastUpdateStatusReasonCode
    ] = Optional.Absent,
    fileSystemConfigs: Optional[
      Iterable[zio.aws.lambda.model.FileSystemConfig]
    ] = Optional.Absent,
    packageType: Optional[zio.aws.lambda.model.PackageType] = Optional.Absent,
    imageConfigResponse: Optional[zio.aws.lambda.model.ImageConfigResponse] =
      Optional.Absent,
    signingProfileVersionArn: Optional[Arn] = Optional.Absent,
    signingJobArn: Optional[Arn] = Optional.Absent,
    architectures: Optional[Iterable[zio.aws.lambda.model.Architecture]] =
      Optional.Absent,
    ephemeralStorage: Optional[zio.aws.lambda.model.EphemeralStorage] =
      Optional.Absent,
    snapStart: Optional[zio.aws.lambda.model.SnapStartResponse] =
      Optional.Absent,
    runtimeVersionConfig: Optional[zio.aws.lambda.model.RuntimeVersionConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PublishVersionResponse = {
    import PublishVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PublishVersionResponse
      .builder()
      .optionallyWith(
        functionName.map(value =>
          NamespacedFunctionName.unwrap(value): java.lang.String
        )
      )(_.functionName)
      .optionallyWith(
        functionArn.map(value =>
          NameSpacedFunctionArn.unwrap(value): java.lang.String
        )
      )(_.functionArn)
      .optionallyWith(runtime.map(value => value.unwrap))(_.runtime)
      .optionallyWith(
        role.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.role)
      .optionallyWith(
        handler.map(value => Handler.unwrap(value): java.lang.String)
      )(_.handler)
      .optionallyWith(codeSize.map(value => value: java.lang.Long))(_.codeSize)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(timeout.map(value => Timeout.unwrap(value): Integer))(
        _.timeout
      )
      .optionallyWith(
        memorySize.map(value => MemorySize.unwrap(value): Integer)
      )(_.memorySize)
      .optionallyWith(
        lastModified.map(value => Timestamp.unwrap(value): java.lang.String)
      )(_.lastModified)
      .optionallyWith(codeSha256.map(value => value: java.lang.String))(
        _.codeSha256
      )
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        kmsKeyArn.map(value => KMSKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(tracingConfig.map(value => value.buildAwsValue()))(
        _.tracingConfig
      )
      .optionallyWith(
        masterArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.masterArn)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .optionallyWith(
        layers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.layers)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value => StateReason.unwrap(value): java.lang.String)
      )(_.stateReason)
      .optionallyWith(stateReasonCode.map(value => value.unwrap))(
        _.stateReasonCode
      )
      .optionallyWith(lastUpdateStatus.map(value => value.unwrap))(
        _.lastUpdateStatus
      )
      .optionallyWith(
        lastUpdateStatusReason.map(value =>
          LastUpdateStatusReason.unwrap(value): java.lang.String
        )
      )(_.lastUpdateStatusReason)
      .optionallyWith(lastUpdateStatusReasonCode.map(value => value.unwrap))(
        _.lastUpdateStatusReasonCode
      )
      .optionallyWith(
        fileSystemConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemConfigs)
      .optionallyWith(packageType.map(value => value.unwrap))(_.packageType)
      .optionallyWith(imageConfigResponse.map(value => value.buildAwsValue()))(
        _.imageConfigResponse
      )
      .optionallyWith(
        signingProfileVersionArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.signingProfileVersionArn)
      .optionallyWith(
        signingJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.signingJobArn)
      .optionallyWith(
        architectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.architecturesWithStrings)
      .optionallyWith(ephemeralStorage.map(value => value.buildAwsValue()))(
        _.ephemeralStorage
      )
      .optionallyWith(snapStart.map(value => value.buildAwsValue()))(
        _.snapStart
      )
      .optionallyWith(runtimeVersionConfig.map(value => value.buildAwsValue()))(
        _.runtimeVersionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.PublishVersionResponse.ReadOnly =
    zio.aws.lambda.model.PublishVersionResponse.wrap(buildAwsValue())
}
object PublishVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PublishVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PublishVersionResponse =
      zio.aws.lambda.model.PublishVersionResponse(
        functionName.map(value => value),
        functionArn.map(value => value),
        runtime.map(value => value),
        role.map(value => value),
        handler.map(value => value),
        codeSize.map(value => value),
        description.map(value => value),
        timeout.map(value => value),
        memorySize.map(value => value),
        lastModified.map(value => value),
        codeSha256.map(value => value),
        version.map(value => value),
        vpcConfig.map(value => value.asEditable),
        deadLetterConfig.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        kmsKeyArn.map(value => value),
        tracingConfig.map(value => value.asEditable),
        masterArn.map(value => value),
        revisionId.map(value => value),
        layers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        state.map(value => value),
        stateReason.map(value => value),
        stateReasonCode.map(value => value),
        lastUpdateStatus.map(value => value),
        lastUpdateStatusReason.map(value => value),
        lastUpdateStatusReasonCode.map(value => value),
        fileSystemConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        packageType.map(value => value),
        imageConfigResponse.map(value => value.asEditable),
        signingProfileVersionArn.map(value => value),
        signingJobArn.map(value => value),
        architectures.map(value => value),
        ephemeralStorage.map(value => value.asEditable),
        snapStart.map(value => value.asEditable),
        runtimeVersionConfig.map(value => value.asEditable)
      )
    def functionName: Optional[NamespacedFunctionName]
    def functionArn: Optional[NameSpacedFunctionArn]
    def runtime: Optional[zio.aws.lambda.model.Runtime]
    def role: Optional[RoleArn]
    def handler: Optional[Handler]
    def codeSize: Optional[Long]
    def description: Optional[Description]
    def timeout: Optional[Timeout]
    def memorySize: Optional[MemorySize]
    def lastModified: Optional[Timestamp]
    def codeSha256: Optional[String]
    def version: Optional[Version]
    def vpcConfig: Optional[zio.aws.lambda.model.VpcConfigResponse.ReadOnly]
    def deadLetterConfig
        : Optional[zio.aws.lambda.model.DeadLetterConfig.ReadOnly]
    def environment: Optional[zio.aws.lambda.model.EnvironmentResponse.ReadOnly]
    def kmsKeyArn: Optional[KMSKeyArn]
    def tracingConfig
        : Optional[zio.aws.lambda.model.TracingConfigResponse.ReadOnly]
    def masterArn: Optional[FunctionArn]
    def revisionId: Optional[String]
    def layers: Optional[List[zio.aws.lambda.model.Layer.ReadOnly]]
    def state: Optional[zio.aws.lambda.model.State]
    def stateReason: Optional[StateReason]
    def stateReasonCode: Optional[zio.aws.lambda.model.StateReasonCode]
    def lastUpdateStatus: Optional[zio.aws.lambda.model.LastUpdateStatus]
    def lastUpdateStatusReason: Optional[LastUpdateStatusReason]
    def lastUpdateStatusReasonCode
        : Optional[zio.aws.lambda.model.LastUpdateStatusReasonCode]
    def fileSystemConfigs
        : Optional[List[zio.aws.lambda.model.FileSystemConfig.ReadOnly]]
    def packageType: Optional[zio.aws.lambda.model.PackageType]
    def imageConfigResponse
        : Optional[zio.aws.lambda.model.ImageConfigResponse.ReadOnly]
    def signingProfileVersionArn: Optional[Arn]
    def signingJobArn: Optional[Arn]
    def architectures: Optional[List[zio.aws.lambda.model.Architecture]]
    def ephemeralStorage
        : Optional[zio.aws.lambda.model.EphemeralStorage.ReadOnly]
    def snapStart: Optional[zio.aws.lambda.model.SnapStartResponse.ReadOnly]
    def runtimeVersionConfig
        : Optional[zio.aws.lambda.model.RuntimeVersionConfig.ReadOnly]
    def getFunctionName: ZIO[Any, AwsError, NamespacedFunctionName] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getFunctionArn: ZIO[Any, AwsError, NameSpacedFunctionArn] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getRuntime: ZIO[Any, AwsError, zio.aws.lambda.model.Runtime] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("role", role)
    def getHandler: ZIO[Any, AwsError, Handler] =
      AwsError.unwrapOptionField("handler", handler)
    def getCodeSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("codeSize", codeSize)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTimeout: ZIO[Any, AwsError, Timeout] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getMemorySize: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("memorySize", memorySize)
    def getLastModified: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getCodeSha256: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codeSha256", codeSha256)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.VpcConfigResponse.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getDeadLetterConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DeadLetterConfig.ReadOnly] =
      AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.EnvironmentResponse.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getKmsKeyArn: ZIO[Any, AwsError, KMSKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getTracingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.TracingConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField("tracingConfig", tracingConfig)
    def getMasterArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("masterArn", masterArn)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getLayers
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Layer.ReadOnly]] =
      AwsError.unwrapOptionField("layers", layers)
    def getState: ZIO[Any, AwsError, zio.aws.lambda.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getStateReasonCode
        : ZIO[Any, AwsError, zio.aws.lambda.model.StateReasonCode] =
      AwsError.unwrapOptionField("stateReasonCode", stateReasonCode)
    def getLastUpdateStatus
        : ZIO[Any, AwsError, zio.aws.lambda.model.LastUpdateStatus] =
      AwsError.unwrapOptionField("lastUpdateStatus", lastUpdateStatus)
    def getLastUpdateStatusReason: ZIO[Any, AwsError, LastUpdateStatusReason] =
      AwsError.unwrapOptionField(
        "lastUpdateStatusReason",
        lastUpdateStatusReason
      )
    def getLastUpdateStatusReasonCode
        : ZIO[Any, AwsError, zio.aws.lambda.model.LastUpdateStatusReasonCode] =
      AwsError.unwrapOptionField(
        "lastUpdateStatusReasonCode",
        lastUpdateStatusReasonCode
      )
    def getFileSystemConfigs: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.FileSystemConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemConfigs", fileSystemConfigs)
    def getPackageType: ZIO[Any, AwsError, zio.aws.lambda.model.PackageType] =
      AwsError.unwrapOptionField("packageType", packageType)
    def getImageConfigResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.ImageConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField("imageConfigResponse", imageConfigResponse)
    def getSigningProfileVersionArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("signingProfileVersionArn", signingProfileVersionArn)
    def getSigningJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("signingJobArn", signingJobArn)
    def getArchitectures
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Architecture]] =
      AwsError.unwrapOptionField("architectures", architectures)
    def getEphemeralStorage
        : ZIO[Any, AwsError, zio.aws.lambda.model.EphemeralStorage.ReadOnly] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
    def getSnapStart
        : ZIO[Any, AwsError, zio.aws.lambda.model.SnapStartResponse.ReadOnly] =
      AwsError.unwrapOptionField("snapStart", snapStart)
    def getRuntimeVersionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.RuntimeVersionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("runtimeVersionConfig", runtimeVersionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PublishVersionResponse
  ) extends zio.aws.lambda.model.PublishVersionResponse.ReadOnly {
    override val functionName: Optional[NamespacedFunctionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionName())
        .map(value =>
          zio.aws.lambda.model.primitives.NamespacedFunctionName(value)
        )
    override val functionArn: Optional[NameSpacedFunctionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionArn())
        .map(value =>
          zio.aws.lambda.model.primitives.NameSpacedFunctionArn(value)
        )
    override val runtime: Optional[zio.aws.lambda.model.Runtime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtime())
        .map(value => zio.aws.lambda.model.Runtime.wrap(value))
    override val role: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.lambda.model.primitives.RoleArn(value))
    override val handler: Optional[Handler] = zio.aws.core.internal
      .optionalFromNullable(impl.handler())
      .map(value => zio.aws.lambda.model.primitives.Handler(value))
    override val codeSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.codeSize())
      .map(value => value: Long)
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val timeout: Optional[Timeout] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value => zio.aws.lambda.model.primitives.Timeout(value))
    override val memorySize: Optional[MemorySize] = zio.aws.core.internal
      .optionalFromNullable(impl.memorySize())
      .map(value => zio.aws.lambda.model.primitives.MemorySize(value))
    override val lastModified: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.lambda.model.primitives.Timestamp(value))
    override val codeSha256: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.codeSha256())
      .map(value => value: String)
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.lambda.model.primitives.Version(value))
    override val vpcConfig
        : Optional[zio.aws.lambda.model.VpcConfigResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.lambda.model.VpcConfigResponse.wrap(value))
    override val deadLetterConfig
        : Optional[zio.aws.lambda.model.DeadLetterConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deadLetterConfig())
        .map(value => zio.aws.lambda.model.DeadLetterConfig.wrap(value))
    override val environment
        : Optional[zio.aws.lambda.model.EnvironmentResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.lambda.model.EnvironmentResponse.wrap(value))
    override val kmsKeyArn: Optional[KMSKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.lambda.model.primitives.KMSKeyArn(value))
    override val tracingConfig
        : Optional[zio.aws.lambda.model.TracingConfigResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tracingConfig())
        .map(value => zio.aws.lambda.model.TracingConfigResponse.wrap(value))
    override val masterArn: Optional[FunctionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.masterArn())
      .map(value => zio.aws.lambda.model.primitives.FunctionArn(value))
    override val revisionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: String)
    override val layers: Optional[List[zio.aws.lambda.model.Layer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.Layer.wrap(item)
          }.toList
        )
    override val state: Optional[zio.aws.lambda.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lambda.model.State.wrap(value))
    override val stateReason: Optional[StateReason] = zio.aws.core.internal
      .optionalFromNullable(impl.stateReason())
      .map(value => zio.aws.lambda.model.primitives.StateReason(value))
    override val stateReasonCode
        : Optional[zio.aws.lambda.model.StateReasonCode] = zio.aws.core.internal
      .optionalFromNullable(impl.stateReasonCode())
      .map(value => zio.aws.lambda.model.StateReasonCode.wrap(value))
    override val lastUpdateStatus
        : Optional[zio.aws.lambda.model.LastUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateStatus())
        .map(value => zio.aws.lambda.model.LastUpdateStatus.wrap(value))
    override val lastUpdateStatusReason: Optional[LastUpdateStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateStatusReason())
        .map(value =>
          zio.aws.lambda.model.primitives.LastUpdateStatusReason(value)
        )
    override val lastUpdateStatusReasonCode
        : Optional[zio.aws.lambda.model.LastUpdateStatusReasonCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateStatusReasonCode())
        .map(value =>
          zio.aws.lambda.model.LastUpdateStatusReasonCode.wrap(value)
        )
    override val fileSystemConfigs
        : Optional[List[zio.aws.lambda.model.FileSystemConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.FileSystemConfig.wrap(item)
          }.toList
        )
    override val packageType: Optional[zio.aws.lambda.model.PackageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageType())
        .map(value => zio.aws.lambda.model.PackageType.wrap(value))
    override val imageConfigResponse
        : Optional[zio.aws.lambda.model.ImageConfigResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageConfigResponse())
        .map(value => zio.aws.lambda.model.ImageConfigResponse.wrap(value))
    override val signingProfileVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.signingProfileVersionArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val signingJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.signingJobArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val architectures
        : Optional[List[zio.aws.lambda.model.Architecture]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architectures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.Architecture.wrap(item)
          }.toList
        )
    override val ephemeralStorage
        : Optional[zio.aws.lambda.model.EphemeralStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ephemeralStorage())
        .map(value => zio.aws.lambda.model.EphemeralStorage.wrap(value))
    override val snapStart
        : Optional[zio.aws.lambda.model.SnapStartResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapStart())
        .map(value => zio.aws.lambda.model.SnapStartResponse.wrap(value))
    override val runtimeVersionConfig
        : Optional[zio.aws.lambda.model.RuntimeVersionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeVersionConfig())
        .map(value => zio.aws.lambda.model.RuntimeVersionConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PublishVersionResponse
  ): zio.aws.lambda.model.PublishVersionResponse.ReadOnly = new Wrapper(impl)
}
