package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFunctionsResponse(
    nextMarker: Optional[String] = Optional.Absent,
    functions: Optional[Iterable[zio.aws.lambda.model.FunctionConfiguration]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListFunctionsResponse = {
    import ListFunctionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListFunctionsResponse
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        functions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.functions)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListFunctionsResponse.ReadOnly =
    zio.aws.lambda.model.ListFunctionsResponse.wrap(buildAwsValue())
}
object ListFunctionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListFunctionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListFunctionsResponse =
      zio.aws.lambda.model.ListFunctionsResponse(
        nextMarker.map(value => value),
        functions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[String]
    def functions
        : Optional[List[zio.aws.lambda.model.FunctionConfiguration.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getFunctions: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.FunctionConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("functions", functions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionsResponse
  ) extends zio.aws.lambda.model.ListFunctionsResponse.ReadOnly {
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
    override val functions
        : Optional[List[zio.aws.lambda.model.FunctionConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.FunctionConfiguration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionsResponse
  ): zio.aws.lambda.model.ListFunctionsResponse.ReadOnly = new Wrapper(impl)
}
