package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuntimeVersionError(
    errorCode: Optional[String] = Optional.Absent,
    message: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.RuntimeVersionError = {
    import RuntimeVersionError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.RuntimeVersionError
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(
        message.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.RuntimeVersionError.ReadOnly =
    zio.aws.lambda.model.RuntimeVersionError.wrap(buildAwsValue())
}
object RuntimeVersionError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.RuntimeVersionError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.RuntimeVersionError =
      zio.aws.lambda.model.RuntimeVersionError(
        errorCode.map(value => value),
        message.map(value => value)
      )
    def errorCode: Optional[String]
    def message: Optional[SensitiveString]
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.RuntimeVersionError
  ) extends zio.aws.lambda.model.RuntimeVersionError.ReadOnly {
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val message: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.lambda.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.RuntimeVersionError
  ): zio.aws.lambda.model.RuntimeVersionError.ReadOnly = new Wrapper(impl)
}
