package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  LayerVersionNumber,
  StatementId,
  LayerPermissionAllowedAction,
  OrganizationId,
  LayerName,
  LayerPermissionAllowedPrincipal
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AddLayerVersionPermissionRequest(
    layerName: LayerName,
    versionNumber: LayerVersionNumber,
    statementId: StatementId,
    action: LayerPermissionAllowedAction,
    principal: LayerPermissionAllowedPrincipal,
    organizationId: Optional[OrganizationId] = Optional.Absent,
    revisionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest = {
    import AddLayerVersionPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest
      .builder()
      .layerName(LayerName.unwrap(layerName): java.lang.String)
      .versionNumber(LayerVersionNumber.unwrap(versionNumber): java.lang.Long)
      .statementId(StatementId.unwrap(statementId): java.lang.String)
      .action(LayerPermissionAllowedAction.unwrap(action): java.lang.String)
      .principal(
        LayerPermissionAllowedPrincipal.unwrap(principal): java.lang.String
      )
      .optionallyWith(
        organizationId.map(value =>
          OrganizationId.unwrap(value): java.lang.String
        )
      )(_.organizationId)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.AddLayerVersionPermissionRequest.ReadOnly =
    zio.aws.lambda.model.AddLayerVersionPermissionRequest.wrap(buildAwsValue())
}
object AddLayerVersionPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.AddLayerVersionPermissionRequest =
      zio.aws.lambda.model.AddLayerVersionPermissionRequest(
        layerName,
        versionNumber,
        statementId,
        action,
        principal,
        organizationId.map(value => value),
        revisionId.map(value => value)
      )
    def layerName: LayerName
    def versionNumber: LayerVersionNumber
    def statementId: StatementId
    def action: LayerPermissionAllowedAction
    def principal: LayerPermissionAllowedPrincipal
    def organizationId: Optional[OrganizationId]
    def revisionId: Optional[String]
    def getLayerName: ZIO[Any, Nothing, LayerName] = ZIO.succeed(layerName)
    def getVersionNumber: ZIO[Any, Nothing, LayerVersionNumber] =
      ZIO.succeed(versionNumber)
    def getStatementId: ZIO[Any, Nothing, StatementId] =
      ZIO.succeed(statementId)
    def getAction: ZIO[Any, Nothing, LayerPermissionAllowedAction] =
      ZIO.succeed(action)
    def getPrincipal: ZIO[Any, Nothing, LayerPermissionAllowedPrincipal] =
      ZIO.succeed(principal)
    def getOrganizationId: ZIO[Any, AwsError, OrganizationId] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest
  ) extends zio.aws.lambda.model.AddLayerVersionPermissionRequest.ReadOnly {
    override val layerName: LayerName =
      zio.aws.lambda.model.primitives.LayerName(impl.layerName())
    override val versionNumber: LayerVersionNumber =
      zio.aws.lambda.model.primitives.LayerVersionNumber(impl.versionNumber())
    override val statementId: StatementId =
      zio.aws.lambda.model.primitives.StatementId(impl.statementId())
    override val action: LayerPermissionAllowedAction =
      zio.aws.lambda.model.primitives
        .LayerPermissionAllowedAction(impl.action())
    override val principal: LayerPermissionAllowedPrincipal =
      zio.aws.lambda.model.primitives
        .LayerPermissionAllowedPrincipal(impl.principal())
    override val organizationId: Optional[OrganizationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationId())
        .map(value => zio.aws.lambda.model.primitives.OrganizationId(value))
    override val revisionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest
  ): zio.aws.lambda.model.AddLayerVersionPermissionRequest.ReadOnly =
    new Wrapper(impl)
}
