package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait UpdateRuntimeOn {
  def unwrap: software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn
}
object UpdateRuntimeOn {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn
  ): zio.aws.lambda.model.UpdateRuntimeOn = value match {
    case software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn.AUTO =>
      val r = Auto
      r
    case software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn.MANUAL =>
      val r = Manual
      r
    case software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn.FUNCTION_UPDATE =>
      val r = FunctionUpdate
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.UpdateRuntimeOn {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn =
      software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn.UNKNOWN_TO_SDK_VERSION
  }
  case object Auto extends zio.aws.lambda.model.UpdateRuntimeOn {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn =
      software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn.AUTO
  }
  case object Manual extends zio.aws.lambda.model.UpdateRuntimeOn {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn =
      software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn.MANUAL
  }
  case object FunctionUpdate extends zio.aws.lambda.model.UpdateRuntimeOn {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn =
      software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn.FUNCTION_UPDATE
  }
}
