package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.FunctionName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetFunctionConcurrencyRequest(functionName: FunctionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest = {
    import GetFunctionConcurrencyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetFunctionConcurrencyRequest.ReadOnly =
    zio.aws.lambda.model.GetFunctionConcurrencyRequest.wrap(buildAwsValue())
}
object GetFunctionConcurrencyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionConcurrencyRequest =
      zio.aws.lambda.model.GetFunctionConcurrencyRequest(functionName)
    def functionName: FunctionName
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest
  ) extends zio.aws.lambda.model.GetFunctionConcurrencyRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest
  ): zio.aws.lambda.model.GetFunctionConcurrencyRequest.ReadOnly = new Wrapper(
    impl
  )
}
