package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait CodeSigningPolicy {
  def unwrap: software.amazon.awssdk.services.lambda.model.CodeSigningPolicy
}
object CodeSigningPolicy {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.CodeSigningPolicy
  ): zio.aws.lambda.model.CodeSigningPolicy = value match {
    case software.amazon.awssdk.services.lambda.model.CodeSigningPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.CodeSigningPolicy.WARN =>
      val r = Warn
      r
    case software.amazon.awssdk.services.lambda.model.CodeSigningPolicy.ENFORCE =>
      val r = Enforce
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.CodeSigningPolicy {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.CodeSigningPolicy =
      software.amazon.awssdk.services.lambda.model.CodeSigningPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object Warn extends zio.aws.lambda.model.CodeSigningPolicy {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.CodeSigningPolicy =
      software.amazon.awssdk.services.lambda.model.CodeSigningPolicy.WARN
  }
  case object Enforce extends zio.aws.lambda.model.CodeSigningPolicy {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.CodeSigningPolicy =
      software.amazon.awssdk.services.lambda.model.CodeSigningPolicy.ENFORCE
  }
}
