package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TracingConfigResponse(
    mode: Optional[zio.aws.lambda.model.TracingMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.TracingConfigResponse = {
    import TracingConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.TracingConfigResponse
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.TracingConfigResponse.ReadOnly =
    zio.aws.lambda.model.TracingConfigResponse.wrap(buildAwsValue())
}
object TracingConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.TracingConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.TracingConfigResponse =
      zio.aws.lambda.model.TracingConfigResponse(mode.map(value => value))
    def mode: Optional[zio.aws.lambda.model.TracingMode]
    def getMode: ZIO[Any, AwsError, zio.aws.lambda.model.TracingMode] =
      AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.TracingConfigResponse
  ) extends zio.aws.lambda.model.TracingConfigResponse.ReadOnly {
    override val mode: Optional[zio.aws.lambda.model.TracingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.lambda.model.TracingMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.TracingConfigResponse
  ): zio.aws.lambda.model.TracingConfigResponse.ReadOnly = new Wrapper(impl)
}
