package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAccountSettingsResponse(
    accountLimit: Optional[zio.aws.lambda.model.AccountLimit] = Optional.Absent,
    accountUsage: Optional[zio.aws.lambda.model.AccountUsage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse = {
    import GetAccountSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse
      .builder()
      .optionallyWith(accountLimit.map(value => value.buildAwsValue()))(
        _.accountLimit
      )
      .optionallyWith(accountUsage.map(value => value.buildAwsValue()))(
        _.accountUsage
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly =
    zio.aws.lambda.model.GetAccountSettingsResponse.wrap(buildAwsValue())
}
object GetAccountSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetAccountSettingsResponse =
      zio.aws.lambda.model.GetAccountSettingsResponse(
        accountLimit.map(value => value.asEditable),
        accountUsage.map(value => value.asEditable)
      )
    def accountLimit: Optional[zio.aws.lambda.model.AccountLimit.ReadOnly]
    def accountUsage: Optional[zio.aws.lambda.model.AccountUsage.ReadOnly]
    def getAccountLimit
        : ZIO[Any, AwsError, zio.aws.lambda.model.AccountLimit.ReadOnly] =
      AwsError.unwrapOptionField("accountLimit", accountLimit)
    def getAccountUsage
        : ZIO[Any, AwsError, zio.aws.lambda.model.AccountUsage.ReadOnly] =
      AwsError.unwrapOptionField("accountUsage", accountUsage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse
  ) extends zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly {
    override val accountLimit
        : Optional[zio.aws.lambda.model.AccountLimit.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountLimit())
        .map(value => zio.aws.lambda.model.AccountLimit.wrap(value))
    override val accountUsage
        : Optional[zio.aws.lambda.model.AccountUsage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountUsage())
        .map(value => zio.aws.lambda.model.AccountUsage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse
  ): zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
