package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.LayerVersionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLayerVersionByArnRequest(arn: LayerVersionArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest = {
    import GetLayerVersionByArnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest
      .builder()
      .arn(LayerVersionArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetLayerVersionByArnRequest.ReadOnly =
    zio.aws.lambda.model.GetLayerVersionByArnRequest.wrap(buildAwsValue())
}
object GetLayerVersionByArnRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetLayerVersionByArnRequest =
      zio.aws.lambda.model.GetLayerVersionByArnRequest(arn)
    def arn: LayerVersionArn
    def getArn: ZIO[Any, Nothing, LayerVersionArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest
  ) extends zio.aws.lambda.model.GetLayerVersionByArnRequest.ReadOnly {
    override val arn: LayerVersionArn =
      zio.aws.lambda.model.primitives.LayerVersionArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest
  ): zio.aws.lambda.model.GetLayerVersionByArnRequest.ReadOnly = new Wrapper(
    impl
  )
}
