package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Qualifier, FunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetFunctionEventInvokeConfigRequest(
    functionName: FunctionName,
    qualifier: Optional[Qualifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest = {
    import GetFunctionEventInvokeConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.GetFunctionEventInvokeConfigRequest.ReadOnly =
    zio.aws.lambda.model.GetFunctionEventInvokeConfigRequest
      .wrap(buildAwsValue())
}
object GetFunctionEventInvokeConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionEventInvokeConfigRequest =
      zio.aws.lambda.model.GetFunctionEventInvokeConfigRequest(
        functionName,
        qualifier.map(value => value)
      )
    def functionName: FunctionName
    def qualifier: Optional[Qualifier]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest
  ) extends zio.aws.lambda.model.GetFunctionEventInvokeConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Optional[Qualifier] = zio.aws.core.internal
      .optionalFromNullable(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest
  ): zio.aws.lambda.model.GetFunctionEventInvokeConfigRequest.ReadOnly =
    new Wrapper(impl)
}
