package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait LastUpdateStatusReasonCode {
  def unwrap
      : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode
}
object LastUpdateStatusReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode
  ): zio.aws.lambda.model.LastUpdateStatusReasonCode = value match {
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.ENI_LIMIT_EXCEEDED =>
      val r = EniLimitExceeded
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INSUFFICIENT_ROLE_PERMISSIONS =>
      val r = InsufficientRolePermissions
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_CONFIGURATION =>
      val r = InvalidConfiguration
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INTERNAL_ERROR =>
      val r = InternalError
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.SUBNET_OUT_OF_IP_ADDRESSES =>
      val r = SubnetOutOfIPAddresses
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_SUBNET =>
      val r = InvalidSubnet
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_SECURITY_GROUP =>
      val r = InvalidSecurityGroup
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.IMAGE_DELETED =>
      val r = ImageDeleted
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.IMAGE_ACCESS_DENIED =>
      val r = ImageAccessDenied
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_IMAGE =>
      val r = InvalidImage
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.KMS_KEY_ACCESS_DENIED =>
      val r = KMSKeyAccessDenied
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.KMS_KEY_NOT_FOUND =>
      val r = KMSKeyNotFound
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_STATE_KMS_KEY =>
      val r = InvalidStateKMSKey
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.DISABLED_KMS_KEY =>
      val r = DisabledKMSKey
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.EFSIO_ERROR =>
      val r = EFSIOError
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.EFS_MOUNT_CONNECTIVITY_ERROR =>
      val r = EFSMountConnectivityError
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.EFS_MOUNT_FAILURE =>
      val r = EFSMountFailure
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.EFS_MOUNT_TIMEOUT =>
      val r = EFSMountTimeout
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_RUNTIME =>
      val r = InvalidRuntime
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_ZIP_FILE_EXCEPTION =>
      val r = InvalidZipFileException
      r
    case software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.FUNCTION_ERROR =>
      val r = FunctionError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object EniLimitExceeded
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.ENI_LIMIT_EXCEEDED
  }
  case object InsufficientRolePermissions
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INSUFFICIENT_ROLE_PERMISSIONS
  }
  case object InvalidConfiguration
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_CONFIGURATION
  }
  case object InternalError
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INTERNAL_ERROR
  }
  case object SubnetOutOfIPAddresses
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.SUBNET_OUT_OF_IP_ADDRESSES
  }
  case object InvalidSubnet
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_SUBNET
  }
  case object InvalidSecurityGroup
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_SECURITY_GROUP
  }
  case object ImageDeleted
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.IMAGE_DELETED
  }
  case object ImageAccessDenied
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.IMAGE_ACCESS_DENIED
  }
  case object InvalidImage
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_IMAGE
  }
  case object KMSKeyAccessDenied
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.KMS_KEY_ACCESS_DENIED
  }
  case object KMSKeyNotFound
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.KMS_KEY_NOT_FOUND
  }
  case object InvalidStateKMSKey
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_STATE_KMS_KEY
  }
  case object DisabledKMSKey
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.DISABLED_KMS_KEY
  }
  case object EFSIOError
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.EFSIO_ERROR
  }
  case object EFSMountConnectivityError
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.EFS_MOUNT_CONNECTIVITY_ERROR
  }
  case object EFSMountFailure
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.EFS_MOUNT_FAILURE
  }
  case object EFSMountTimeout
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.EFS_MOUNT_TIMEOUT
  }
  case object InvalidRuntime
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_RUNTIME
  }
  case object InvalidZipFileException
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.INVALID_ZIP_FILE_EXCEPTION
  }
  case object FunctionError
      extends zio.aws.lambda.model.LastUpdateStatusReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode =
      software.amazon.awssdk.services.lambda.model.LastUpdateStatusReasonCode.FUNCTION_ERROR
  }
}
