package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Qualifier, FunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRuntimeManagementConfigRequest(
    functionName: FunctionName,
    qualifier: Optional[Qualifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigRequest = {
    import GetRuntimeManagementConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.GetRuntimeManagementConfigRequest.ReadOnly =
    zio.aws.lambda.model.GetRuntimeManagementConfigRequest.wrap(buildAwsValue())
}
object GetRuntimeManagementConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetRuntimeManagementConfigRequest =
      zio.aws.lambda.model.GetRuntimeManagementConfigRequest(
        functionName,
        qualifier.map(value => value)
      )
    def functionName: FunctionName
    def qualifier: Optional[Qualifier]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigRequest
  ) extends zio.aws.lambda.model.GetRuntimeManagementConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Optional[Qualifier] = zio.aws.core.internal
      .optionalFromNullable(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigRequest
  ): zio.aws.lambda.model.GetRuntimeManagementConfigRequest.ReadOnly =
    new Wrapper(impl)
}
