package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Version, Blob, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InvokeResponse(
    statusCode: Optional[Integer] = Optional.Absent,
    functionError: Optional[String] = Optional.Absent,
    logResult: Optional[String] = Optional.Absent,
    payload: Optional[Blob] = Optional.Absent,
    executedVersion: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.InvokeResponse = {
    import InvokeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.InvokeResponse
      .builder()
      .optionallyWith(statusCode.map(value => value: java.lang.Integer))(
        _.statusCode
      )
      .optionallyWith(functionError.map(value => value: java.lang.String))(
        _.functionError
      )
      .optionallyWith(logResult.map(value => value: java.lang.String))(
        _.logResult
      )
      .optionallyWith(
        payload.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.payload)
      .optionallyWith(
        executedVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.executedVersion)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.InvokeResponse.ReadOnly =
    zio.aws.lambda.model.InvokeResponse.wrap(buildAwsValue())
}
object InvokeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.InvokeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.InvokeResponse =
      zio.aws.lambda.model.InvokeResponse(
        statusCode.map(value => value),
        functionError.map(value => value),
        logResult.map(value => value),
        payload.map(value => value),
        executedVersion.map(value => value)
      )
    def statusCode: Optional[Integer]
    def functionError: Optional[String]
    def logResult: Optional[String]
    def payload: Optional[Blob]
    def executedVersion: Optional[Version]
    def getStatusCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getFunctionError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("functionError", functionError)
    def getLogResult: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logResult", logResult)
    def getPayload: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("payload", payload)
    def getExecutedVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("executedVersion", executedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.InvokeResponse
  ) extends zio.aws.lambda.model.InvokeResponse.ReadOnly {
    override val statusCode: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => value: Integer)
    override val functionError: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.functionError())
      .map(value => value: String)
    override val logResult: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logResult())
      .map(value => value: String)
    override val payload: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.payload())
      .map(value =>
        zio.aws.lambda.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val executedVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.executedVersion())
      .map(value => zio.aws.lambda.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.InvokeResponse
  ): zio.aws.lambda.model.InvokeResponse.ReadOnly = new Wrapper(impl)
}
