package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SnapStartResponse(
    applyOn: Optional[zio.aws.lambda.model.SnapStartApplyOn] = Optional.Absent,
    optimizationStatus: Optional[
      zio.aws.lambda.model.SnapStartOptimizationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.SnapStartResponse = {
    import SnapStartResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.SnapStartResponse
      .builder()
      .optionallyWith(applyOn.map(value => value.unwrap))(_.applyOn)
      .optionallyWith(optimizationStatus.map(value => value.unwrap))(
        _.optimizationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.SnapStartResponse.ReadOnly =
    zio.aws.lambda.model.SnapStartResponse.wrap(buildAwsValue())
}
object SnapStartResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.SnapStartResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.SnapStartResponse =
      zio.aws.lambda.model.SnapStartResponse(
        applyOn.map(value => value),
        optimizationStatus.map(value => value)
      )
    def applyOn: Optional[zio.aws.lambda.model.SnapStartApplyOn]
    def optimizationStatus
        : Optional[zio.aws.lambda.model.SnapStartOptimizationStatus]
    def getApplyOn: ZIO[Any, AwsError, zio.aws.lambda.model.SnapStartApplyOn] =
      AwsError.unwrapOptionField("applyOn", applyOn)
    def getOptimizationStatus
        : ZIO[Any, AwsError, zio.aws.lambda.model.SnapStartOptimizationStatus] =
      AwsError.unwrapOptionField("optimizationStatus", optimizationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.SnapStartResponse
  ) extends zio.aws.lambda.model.SnapStartResponse.ReadOnly {
    override val applyOn: Optional[zio.aws.lambda.model.SnapStartApplyOn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applyOn())
        .map(value => zio.aws.lambda.model.SnapStartApplyOn.wrap(value))
    override val optimizationStatus
        : Optional[zio.aws.lambda.model.SnapStartOptimizationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optimizationStatus())
        .map(value =>
          zio.aws.lambda.model.SnapStartOptimizationStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.SnapStartResponse
  ): zio.aws.lambda.model.SnapStartResponse.ReadOnly = new Wrapper(impl)
}
