package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  MaximumRetryAttemptsEventSourceMapping,
  BatchSize,
  BisectBatchOnFunctionError,
  MaximumBatchingWindowInSeconds,
  ParallelizationFactor,
  FunctionName,
  Enabled,
  TumblingWindowInSeconds,
  MaximumRecordAgeInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateEventSourceMappingRequest(
    uuid: String,
    functionName: Optional[FunctionName] = Optional.Absent,
    enabled: Optional[Enabled] = Optional.Absent,
    batchSize: Optional[BatchSize] = Optional.Absent,
    filterCriteria: Optional[zio.aws.lambda.model.FilterCriteria] =
      Optional.Absent,
    maximumBatchingWindowInSeconds: Optional[MaximumBatchingWindowInSeconds] =
      Optional.Absent,
    destinationConfig: Optional[zio.aws.lambda.model.DestinationConfig] =
      Optional.Absent,
    maximumRecordAgeInSeconds: Optional[MaximumRecordAgeInSeconds] =
      Optional.Absent,
    bisectBatchOnFunctionError: Optional[BisectBatchOnFunctionError] =
      Optional.Absent,
    maximumRetryAttempts: Optional[MaximumRetryAttemptsEventSourceMapping] =
      Optional.Absent,
    parallelizationFactor: Optional[ParallelizationFactor] = Optional.Absent,
    sourceAccessConfigurations: Optional[
      Iterable[zio.aws.lambda.model.SourceAccessConfiguration]
    ] = Optional.Absent,
    tumblingWindowInSeconds: Optional[TumblingWindowInSeconds] =
      Optional.Absent,
    functionResponseTypes: Optional[
      Iterable[zio.aws.lambda.model.FunctionResponseType]
    ] = Optional.Absent,
    scalingConfig: Optional[zio.aws.lambda.model.ScalingConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest = {
    import UpdateEventSourceMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest
      .builder()
      .uuid(uuid: java.lang.String)
      .optionallyWith(
        functionName.map(value => FunctionName.unwrap(value): java.lang.String)
      )(_.functionName)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(batchSize.map(value => BatchSize.unwrap(value): Integer))(
        _.batchSize
      )
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maximumBatchingWindowInSeconds.map(value =>
          MaximumBatchingWindowInSeconds.unwrap(value): Integer
        )
      )(_.maximumBatchingWindowInSeconds)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .optionallyWith(
        maximumRecordAgeInSeconds.map(value =>
          MaximumRecordAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumRecordAgeInSeconds)
      .optionallyWith(
        bisectBatchOnFunctionError.map(value =>
          BisectBatchOnFunctionError.unwrap(value): java.lang.Boolean
        )
      )(_.bisectBatchOnFunctionError)
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttemptsEventSourceMapping.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .optionallyWith(
        parallelizationFactor.map(value =>
          ParallelizationFactor.unwrap(value): Integer
        )
      )(_.parallelizationFactor)
      .optionallyWith(
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceAccessConfigurations)
      .optionallyWith(
        tumblingWindowInSeconds.map(value =>
          TumblingWindowInSeconds.unwrap(value): Integer
        )
      )(_.tumblingWindowInSeconds)
      .optionallyWith(
        functionResponseTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.functionResponseTypesWithStrings)
      .optionallyWith(scalingConfig.map(value => value.buildAwsValue()))(
        _.scalingConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.UpdateEventSourceMappingRequest.ReadOnly =
    zio.aws.lambda.model.UpdateEventSourceMappingRequest.wrap(buildAwsValue())
}
object UpdateEventSourceMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateEventSourceMappingRequest =
      zio.aws.lambda.model.UpdateEventSourceMappingRequest(
        uuid,
        functionName.map(value => value),
        enabled.map(value => value),
        batchSize.map(value => value),
        filterCriteria.map(value => value.asEditable),
        maximumBatchingWindowInSeconds.map(value => value),
        destinationConfig.map(value => value.asEditable),
        maximumRecordAgeInSeconds.map(value => value),
        bisectBatchOnFunctionError.map(value => value),
        maximumRetryAttempts.map(value => value),
        parallelizationFactor.map(value => value),
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tumblingWindowInSeconds.map(value => value),
        functionResponseTypes.map(value => value),
        scalingConfig.map(value => value.asEditable)
      )
    def uuid: String
    def functionName: Optional[FunctionName]
    def enabled: Optional[Enabled]
    def batchSize: Optional[BatchSize]
    def filterCriteria: Optional[zio.aws.lambda.model.FilterCriteria.ReadOnly]
    def maximumBatchingWindowInSeconds: Optional[MaximumBatchingWindowInSeconds]
    def destinationConfig
        : Optional[zio.aws.lambda.model.DestinationConfig.ReadOnly]
    def maximumRecordAgeInSeconds: Optional[MaximumRecordAgeInSeconds]
    def bisectBatchOnFunctionError: Optional[BisectBatchOnFunctionError]
    def maximumRetryAttempts: Optional[MaximumRetryAttemptsEventSourceMapping]
    def parallelizationFactor: Optional[ParallelizationFactor]
    def sourceAccessConfigurations: Optional[
      List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]
    ]
    def tumblingWindowInSeconds: Optional[TumblingWindowInSeconds]
    def functionResponseTypes
        : Optional[List[zio.aws.lambda.model.FunctionResponseType]]
    def scalingConfig: Optional[zio.aws.lambda.model.ScalingConfig.ReadOnly]
    def getUuid: ZIO[Any, Nothing, String] = ZIO.succeed(uuid)
    def getFunctionName: ZIO[Any, AwsError, FunctionName] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getBatchSize: ZIO[Any, AwsError, BatchSize] =
      AwsError.unwrapOptionField("batchSize", batchSize)
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.lambda.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaximumBatchingWindowInSeconds
        : ZIO[Any, AwsError, MaximumBatchingWindowInSeconds] =
      AwsError.unwrapOptionField(
        "maximumBatchingWindowInSeconds",
        maximumBatchingWindowInSeconds
      )
    def getDestinationConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      AwsError.unwrapOptionField("destinationConfig", destinationConfig)
    def getMaximumRecordAgeInSeconds
        : ZIO[Any, AwsError, MaximumRecordAgeInSeconds] = AwsError
      .unwrapOptionField("maximumRecordAgeInSeconds", maximumRecordAgeInSeconds)
    def getBisectBatchOnFunctionError
        : ZIO[Any, AwsError, BisectBatchOnFunctionError] =
      AwsError.unwrapOptionField(
        "bisectBatchOnFunctionError",
        bisectBatchOnFunctionError
      )
    def getMaximumRetryAttempts
        : ZIO[Any, AwsError, MaximumRetryAttemptsEventSourceMapping] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
    def getParallelizationFactor: ZIO[Any, AwsError, ParallelizationFactor] =
      AwsError.unwrapOptionField("parallelizationFactor", parallelizationFactor)
    def getSourceAccessConfigurations: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sourceAccessConfigurations",
      sourceAccessConfigurations
    )
    def getTumblingWindowInSeconds
        : ZIO[Any, AwsError, TumblingWindowInSeconds] = AwsError
      .unwrapOptionField("tumblingWindowInSeconds", tumblingWindowInSeconds)
    def getFunctionResponseTypes
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.FunctionResponseType]] =
      AwsError.unwrapOptionField("functionResponseTypes", functionResponseTypes)
    def getScalingConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.ScalingConfig.ReadOnly] =
      AwsError.unwrapOptionField("scalingConfig", scalingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest
  ) extends zio.aws.lambda.model.UpdateEventSourceMappingRequest.ReadOnly {
    override val uuid: String = impl.uuid(): String
    override val functionName: Optional[FunctionName] = zio.aws.core.internal
      .optionalFromNullable(impl.functionName())
      .map(value => zio.aws.lambda.model.primitives.FunctionName(value))
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.lambda.model.primitives.Enabled(value))
    override val batchSize: Optional[BatchSize] = zio.aws.core.internal
      .optionalFromNullable(impl.batchSize())
      .map(value => zio.aws.lambda.model.primitives.BatchSize(value))
    override val filterCriteria
        : Optional[zio.aws.lambda.model.FilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriteria())
        .map(value => zio.aws.lambda.model.FilterCriteria.wrap(value))
    override val maximumBatchingWindowInSeconds
        : Optional[MaximumBatchingWindowInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumBatchingWindowInSeconds())
      .map(value =>
        zio.aws.lambda.model.primitives.MaximumBatchingWindowInSeconds(value)
      )
    override val destinationConfig
        : Optional[zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationConfig())
        .map(value => zio.aws.lambda.model.DestinationConfig.wrap(value))
    override val maximumRecordAgeInSeconds
        : Optional[MaximumRecordAgeInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumRecordAgeInSeconds())
      .map(value =>
        zio.aws.lambda.model.primitives.MaximumRecordAgeInSeconds(value)
      )
    override val bisectBatchOnFunctionError
        : Optional[BisectBatchOnFunctionError] = zio.aws.core.internal
      .optionalFromNullable(impl.bisectBatchOnFunctionError())
      .map(value =>
        zio.aws.lambda.model.primitives.BisectBatchOnFunctionError(value)
      )
    override val maximumRetryAttempts
        : Optional[MaximumRetryAttemptsEventSourceMapping] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumRetryAttempts())
        .map(value =>
          zio.aws.lambda.model.primitives
            .MaximumRetryAttemptsEventSourceMapping(value)
        )
    override val parallelizationFactor: Optional[ParallelizationFactor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelizationFactor())
        .map(value =>
          zio.aws.lambda.model.primitives.ParallelizationFactor(value)
        )
    override val sourceAccessConfigurations: Optional[
      List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceAccessConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.SourceAccessConfiguration.wrap(item)
        }.toList
      )
    override val tumblingWindowInSeconds: Optional[TumblingWindowInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tumblingWindowInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.TumblingWindowInSeconds(value)
        )
    override val functionResponseTypes
        : Optional[List[zio.aws.lambda.model.FunctionResponseType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionResponseTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.FunctionResponseType.wrap(item)
          }.toList
        )
    override val scalingConfig
        : Optional[zio.aws.lambda.model.ScalingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingConfig())
        .map(value => zio.aws.lambda.model.ScalingConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest
  ): zio.aws.lambda.model.UpdateEventSourceMappingRequest.ReadOnly =
    new Wrapper(impl)
}
