package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  Description,
  Version,
  Alias,
  FunctionArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAliasResponse(
    aliasArn: Optional[FunctionArn] = Optional.Absent,
    name: Optional[Alias] = Optional.Absent,
    functionVersion: Optional[Version] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    routingConfig: Optional[zio.aws.lambda.model.AliasRoutingConfiguration] =
      Optional.Absent,
    revisionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CreateAliasResponse = {
    import CreateAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CreateAliasResponse
      .builder()
      .optionallyWith(
        aliasArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.aliasArn)
      .optionallyWith(name.map(value => Alias.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        functionVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.functionVersion)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(routingConfig.map(value => value.buildAwsValue()))(
        _.routingConfig
      )
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.CreateAliasResponse.ReadOnly =
    zio.aws.lambda.model.CreateAliasResponse.wrap(buildAwsValue())
}
object CreateAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CreateAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CreateAliasResponse =
      zio.aws.lambda.model.CreateAliasResponse(
        aliasArn.map(value => value),
        name.map(value => value),
        functionVersion.map(value => value),
        description.map(value => value),
        routingConfig.map(value => value.asEditable),
        revisionId.map(value => value)
      )
    def aliasArn: Optional[FunctionArn]
    def name: Optional[Alias]
    def functionVersion: Optional[Version]
    def description: Optional[Description]
    def routingConfig
        : Optional[zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly]
    def revisionId: Optional[String]
    def getAliasArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("aliasArn", aliasArn)
    def getName: ZIO[Any, AwsError, Alias] =
      AwsError.unwrapOptionField("name", name)
    def getFunctionVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("functionVersion", functionVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("routingConfig", routingConfig)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CreateAliasResponse
  ) extends zio.aws.lambda.model.CreateAliasResponse.ReadOnly {
    override val aliasArn: Optional[FunctionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.aliasArn())
      .map(value => zio.aws.lambda.model.primitives.FunctionArn(value))
    override val name: Optional[Alias] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lambda.model.primitives.Alias(value))
    override val functionVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.functionVersion())
      .map(value => zio.aws.lambda.model.primitives.Version(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val routingConfig
        : Optional[zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingConfig())
        .map(value =>
          zio.aws.lambda.model.AliasRoutingConfiguration.wrap(value)
        )
    override val revisionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CreateAliasResponse
  ): zio.aws.lambda.model.CreateAliasResponse.ReadOnly = new Wrapper(impl)
}
