package zio.aws.lambda
import zio.aws.lambda.model.GetEventSourceMappingResponse.ReadOnly
import zio.aws.lambda.model.{
  GetProvisionedConcurrencyConfigRequest,
  GetLayerVersionRequest,
  GetFunctionConfigurationRequest,
  PutFunctionEventInvokeConfigRequest,
  GetFunctionCodeSigningConfigRequest,
  ListFunctionUrlConfigsRequest,
  AddLayerVersionPermissionRequest,
  InvokeRequest,
  ListLayerVersionsRequest,
  PutFunctionConcurrencyRequest,
  GetCodeSigningConfigRequest,
  DeleteLayerVersionRequest,
  PublishVersionRequest,
  DeleteCodeSigningConfigRequest,
  DeleteProvisionedConcurrencyConfigRequest,
  UpdateAliasRequest,
  GetFunctionRequest,
  UpdateFunctionConfigurationRequest,
  ListTagsRequest,
  CreateAliasRequest,
  DeleteFunctionRequest,
  ListLayersRequest,
  ListVersionsByFunctionRequest,
  ListFunctionsByCodeSigningConfigRequest,
  DeleteAliasRequest,
  DeleteFunctionCodeSigningConfigRequest,
  ListAliasesRequest,
  PutProvisionedConcurrencyConfigRequest,
  CreateFunctionUrlConfigRequest,
  GetFunctionEventInvokeConfigRequest,
  DeleteFunctionConcurrencyRequest,
  DeleteEventSourceMappingRequest,
  UpdateFunctionEventInvokeConfigRequest,
  ListCodeSigningConfigsRequest,
  DeleteFunctionUrlConfigRequest,
  DeleteFunctionEventInvokeConfigRequest,
  CreateCodeSigningConfigRequest,
  UpdateFunctionCodeRequest,
  CreateEventSourceMappingRequest,
  ListFunctionEventInvokeConfigsRequest,
  CreateFunctionRequest,
  GetPolicyRequest,
  ListEventSourceMappingsRequest,
  ListFunctionsRequest,
  UntagResourceRequest,
  ListProvisionedConcurrencyConfigsRequest,
  UpdateEventSourceMappingRequest,
  GetFunctionUrlConfigRequest,
  GetFunctionConcurrencyRequest,
  UpdateCodeSigningConfigRequest,
  GetLayerVersionPolicyRequest,
  RemoveLayerVersionPermissionRequest,
  PublishLayerVersionRequest,
  AddPermissionRequest,
  RemovePermissionRequest,
  GetEventSourceMappingRequest,
  UpdateFunctionUrlConfigRequest,
  GetAccountSettingsRequest,
  TagResourceRequest,
  GetAliasRequest,
  PutFunctionCodeSigningConfigRequest,
  GetLayerVersionByArnRequest
}
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.lambda.LambdaAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.lambda.model.primitives.FunctionArn
import zio.stream.ZStream
object LambdaMock extends Mock[Lambda] {
  object ListEventSourceMappings
      extends Stream[
        ListEventSourceMappingsRequest,
        AwsError,
        zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly
      ]
  object ListEventSourceMappingsPaginated
      extends Effect[
        ListEventSourceMappingsRequest,
        AwsError,
        zio.aws.lambda.model.ListEventSourceMappingsResponse.ReadOnly
      ]
  object GetLayerVersion
      extends Effect[
        GetLayerVersionRequest,
        AwsError,
        zio.aws.lambda.model.GetLayerVersionResponse.ReadOnly
      ]
  object PutFunctionCodeSigningConfig
      extends Effect[
        PutFunctionCodeSigningConfigRequest,
        AwsError,
        zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse.ReadOnly
      ]
  object UpdateEventSourceMapping
      extends Effect[
        UpdateEventSourceMappingRequest,
        AwsError,
        zio.aws.lambda.model.UpdateEventSourceMappingResponse.ReadOnly
      ]
  object DeleteEventSourceMapping
      extends Effect[
        DeleteEventSourceMappingRequest,
        AwsError,
        zio.aws.lambda.model.DeleteEventSourceMappingResponse.ReadOnly
      ]
  object GetFunctionEventInvokeConfig
      extends Effect[
        GetFunctionEventInvokeConfigRequest,
        AwsError,
        zio.aws.lambda.model.GetFunctionEventInvokeConfigResponse.ReadOnly
      ]
  object UpdateFunctionCode
      extends Effect[
        UpdateFunctionCodeRequest,
        AwsError,
        zio.aws.lambda.model.UpdateFunctionCodeResponse.ReadOnly
      ]
  object AddLayerVersionPermission
      extends Effect[
        AddLayerVersionPermissionRequest,
        AwsError,
        zio.aws.lambda.model.AddLayerVersionPermissionResponse.ReadOnly
      ]
  object ListFunctionsByCodeSigningConfig
      extends Stream[
        ListFunctionsByCodeSigningConfigRequest,
        AwsError,
        FunctionArn
      ]
  object ListFunctionsByCodeSigningConfigPaginated
      extends Effect[
        ListFunctionsByCodeSigningConfigRequest,
        AwsError,
        zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse.ReadOnly
      ]
  object Invoke
      extends Effect[
        InvokeRequest,
        AwsError,
        zio.aws.lambda.model.InvokeResponse.ReadOnly
      ]
  object ListTags
      extends Effect[
        ListTagsRequest,
        AwsError,
        zio.aws.lambda.model.ListTagsResponse.ReadOnly
      ]
  object PublishLayerVersion
      extends Effect[
        PublishLayerVersionRequest,
        AwsError,
        zio.aws.lambda.model.PublishLayerVersionResponse.ReadOnly
      ]
  object GetCodeSigningConfig
      extends Effect[
        GetCodeSigningConfigRequest,
        AwsError,
        zio.aws.lambda.model.GetCodeSigningConfigResponse.ReadOnly
      ]
  object ListFunctionEventInvokeConfigs
      extends Stream[
        ListFunctionEventInvokeConfigsRequest,
        AwsError,
        zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly
      ]
  object ListFunctionEventInvokeConfigsPaginated
      extends Effect[
        ListFunctionEventInvokeConfigsRequest,
        AwsError,
        zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse.ReadOnly
      ]
  object ListLayers
      extends Stream[
        ListLayersRequest,
        AwsError,
        zio.aws.lambda.model.LayersListItem.ReadOnly
      ]
  object ListLayersPaginated
      extends Effect[
        ListLayersRequest,
        AwsError,
        zio.aws.lambda.model.ListLayersResponse.ReadOnly
      ]
  object ListFunctionUrlConfigs
      extends Stream[
        ListFunctionUrlConfigsRequest,
        AwsError,
        zio.aws.lambda.model.FunctionUrlConfig.ReadOnly
      ]
  object ListFunctionUrlConfigsPaginated
      extends Effect[
        ListFunctionUrlConfigsRequest,
        AwsError,
        zio.aws.lambda.model.ListFunctionUrlConfigsResponse.ReadOnly
      ]
  object GetEventSourceMapping
      extends Effect[GetEventSourceMappingRequest, AwsError, ReadOnly]
  object RemoveLayerVersionPermission
      extends Effect[RemoveLayerVersionPermissionRequest, AwsError, Unit]
  object UpdateFunctionEventInvokeConfig
      extends Effect[
        UpdateFunctionEventInvokeConfigRequest,
        AwsError,
        zio.aws.lambda.model.UpdateFunctionEventInvokeConfigResponse.ReadOnly
      ]
  object CreateFunctionUrlConfig
      extends Effect[
        CreateFunctionUrlConfigRequest,
        AwsError,
        zio.aws.lambda.model.CreateFunctionUrlConfigResponse.ReadOnly
      ]
  object DeleteFunctionEventInvokeConfig
      extends Effect[DeleteFunctionEventInvokeConfigRequest, AwsError, Unit]
  object DeleteCodeSigningConfig
      extends Effect[
        DeleteCodeSigningConfigRequest,
        AwsError,
        zio.aws.lambda.model.DeleteCodeSigningConfigResponse.ReadOnly
      ]
  object DeleteFunction extends Effect[DeleteFunctionRequest, AwsError, Unit]
  object PutProvisionedConcurrencyConfig
      extends Effect[
        PutProvisionedConcurrencyConfigRequest,
        AwsError,
        zio.aws.lambda.model.PutProvisionedConcurrencyConfigResponse.ReadOnly
      ]
  object DeleteProvisionedConcurrencyConfig
      extends Effect[DeleteProvisionedConcurrencyConfigRequest, AwsError, Unit]
  object DeleteFunctionUrlConfig
      extends Effect[DeleteFunctionUrlConfigRequest, AwsError, Unit]
  object ListAliases
      extends Stream[
        ListAliasesRequest,
        AwsError,
        zio.aws.lambda.model.AliasConfiguration.ReadOnly
      ]
  object ListAliasesPaginated
      extends Effect[
        ListAliasesRequest,
        AwsError,
        zio.aws.lambda.model.ListAliasesResponse.ReadOnly
      ]
  object DeleteLayerVersion
      extends Effect[DeleteLayerVersionRequest, AwsError, Unit]
  object ListProvisionedConcurrencyConfigs
      extends Stream[
        ListProvisionedConcurrencyConfigsRequest,
        AwsError,
        zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly
      ]
  object ListProvisionedConcurrencyConfigsPaginated
      extends Effect[
        ListProvisionedConcurrencyConfigsRequest,
        AwsError,
        zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse.ReadOnly
      ]
  object PutFunctionConcurrency
      extends Effect[
        PutFunctionConcurrencyRequest,
        AwsError,
        zio.aws.lambda.model.PutFunctionConcurrencyResponse.ReadOnly
      ]
  object AddPermission
      extends Effect[
        AddPermissionRequest,
        AwsError,
        zio.aws.lambda.model.AddPermissionResponse.ReadOnly
      ]
  object GetProvisionedConcurrencyConfig
      extends Effect[
        GetProvisionedConcurrencyConfigRequest,
        AwsError,
        zio.aws.lambda.model.GetProvisionedConcurrencyConfigResponse.ReadOnly
      ]
  object UpdateFunctionConfiguration
      extends Effect[
        UpdateFunctionConfigurationRequest,
        AwsError,
        zio.aws.lambda.model.UpdateFunctionConfigurationResponse.ReadOnly
      ]
  object ListVersionsByFunction
      extends Stream[
        ListVersionsByFunctionRequest,
        AwsError,
        zio.aws.lambda.model.FunctionConfiguration.ReadOnly
      ]
  object ListVersionsByFunctionPaginated
      extends Effect[
        ListVersionsByFunctionRequest,
        AwsError,
        zio.aws.lambda.model.ListVersionsByFunctionResponse.ReadOnly
      ]
  object UpdateAlias
      extends Effect[
        UpdateAliasRequest,
        AwsError,
        zio.aws.lambda.model.UpdateAliasResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object CreateAlias
      extends Effect[
        CreateAliasRequest,
        AwsError,
        zio.aws.lambda.model.CreateAliasResponse.ReadOnly
      ]
  object GetFunctionUrlConfig
      extends Effect[
        GetFunctionUrlConfigRequest,
        AwsError,
        zio.aws.lambda.model.GetFunctionUrlConfigResponse.ReadOnly
      ]
  object UpdateFunctionUrlConfig
      extends Effect[
        UpdateFunctionUrlConfigRequest,
        AwsError,
        zio.aws.lambda.model.UpdateFunctionUrlConfigResponse.ReadOnly
      ]
  object PutFunctionEventInvokeConfig
      extends Effect[
        PutFunctionEventInvokeConfigRequest,
        AwsError,
        zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse.ReadOnly
      ]
  object RemovePermission
      extends Effect[RemovePermissionRequest, AwsError, Unit]
  object GetFunctionConfiguration
      extends Effect[
        GetFunctionConfigurationRequest,
        AwsError,
        zio.aws.lambda.model.GetFunctionConfigurationResponse.ReadOnly
      ]
  object GetFunctionCodeSigningConfig
      extends Effect[
        GetFunctionCodeSigningConfigRequest,
        AwsError,
        zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse.ReadOnly
      ]
  object GetLayerVersionPolicy
      extends Effect[
        GetLayerVersionPolicyRequest,
        AwsError,
        zio.aws.lambda.model.GetLayerVersionPolicyResponse.ReadOnly
      ]
  object ListCodeSigningConfigs
      extends Stream[
        ListCodeSigningConfigsRequest,
        AwsError,
        zio.aws.lambda.model.CodeSigningConfig.ReadOnly
      ]
  object ListCodeSigningConfigsPaginated
      extends Effect[
        ListCodeSigningConfigsRequest,
        AwsError,
        zio.aws.lambda.model.ListCodeSigningConfigsResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object UpdateCodeSigningConfig
      extends Effect[
        UpdateCodeSigningConfigRequest,
        AwsError,
        zio.aws.lambda.model.UpdateCodeSigningConfigResponse.ReadOnly
      ]
  object DeleteAlias extends Effect[DeleteAliasRequest, AwsError, Unit]
  object GetAlias
      extends Effect[
        GetAliasRequest,
        AwsError,
        zio.aws.lambda.model.GetAliasResponse.ReadOnly
      ]
  object CreateEventSourceMapping
      extends Effect[
        CreateEventSourceMappingRequest,
        AwsError,
        zio.aws.lambda.model.CreateEventSourceMappingResponse.ReadOnly
      ]
  object GetLayerVersionByArn
      extends Effect[
        GetLayerVersionByArnRequest,
        AwsError,
        zio.aws.lambda.model.GetLayerVersionByArnResponse.ReadOnly
      ]
  object GetFunctionConcurrency
      extends Effect[
        GetFunctionConcurrencyRequest,
        AwsError,
        zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly
      ]
  object ListFunctions
      extends Stream[
        ListFunctionsRequest,
        AwsError,
        zio.aws.lambda.model.FunctionConfiguration.ReadOnly
      ]
  object ListFunctionsPaginated
      extends Effect[
        ListFunctionsRequest,
        AwsError,
        zio.aws.lambda.model.ListFunctionsResponse.ReadOnly
      ]
  object GetPolicy
      extends Effect[
        GetPolicyRequest,
        AwsError,
        zio.aws.lambda.model.GetPolicyResponse.ReadOnly
      ]
  object ListLayerVersions
      extends Stream[
        ListLayerVersionsRequest,
        AwsError,
        zio.aws.lambda.model.LayerVersionsListItem.ReadOnly
      ]
  object ListLayerVersionsPaginated
      extends Effect[
        ListLayerVersionsRequest,
        AwsError,
        zio.aws.lambda.model.ListLayerVersionsResponse.ReadOnly
      ]
  object DeleteFunctionConcurrency
      extends Effect[DeleteFunctionConcurrencyRequest, AwsError, Unit]
  object CreateCodeSigningConfig
      extends Effect[
        CreateCodeSigningConfigRequest,
        AwsError,
        zio.aws.lambda.model.CreateCodeSigningConfigResponse.ReadOnly
      ]
  object PublishVersion
      extends Effect[
        PublishVersionRequest,
        AwsError,
        zio.aws.lambda.model.PublishVersionResponse.ReadOnly
      ]
  object GetAccountSettings
      extends Effect[
        GetAccountSettingsRequest,
        AwsError,
        zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly
      ]
  object DeleteFunctionCodeSigningConfig
      extends Effect[DeleteFunctionCodeSigningConfigRequest, AwsError, Unit]
  object CreateFunction
      extends Effect[
        CreateFunctionRequest,
        AwsError,
        zio.aws.lambda.model.CreateFunctionResponse.ReadOnly
      ]
  object GetFunction
      extends Effect[
        GetFunctionRequest,
        AwsError,
        zio.aws.lambda.model.GetFunctionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Lambda] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Lambda] { rts =>
        zio.ZIO.succeed {
          new Lambda {
            val api: LambdaAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Lambda = this
            def listEventSourceMappings(
                request: ListEventSourceMappingsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEventSourceMappings, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEventSourceMappingsPaginated(
                request: ListEventSourceMappingsRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.ListEventSourceMappingsResponse.ReadOnly
            ] = proxy(ListEventSourceMappingsPaginated, request)
            def getLayerVersion(request: GetLayerVersionRequest): IO[
              AwsError,
              zio.aws.lambda.model.GetLayerVersionResponse.ReadOnly
            ] = proxy(GetLayerVersion, request)
            def putFunctionCodeSigningConfig(
                request: PutFunctionCodeSigningConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse.ReadOnly
            ] = proxy(PutFunctionCodeSigningConfig, request)
            def updateEventSourceMapping(
                request: UpdateEventSourceMappingRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.UpdateEventSourceMappingResponse.ReadOnly
            ] = proxy(UpdateEventSourceMapping, request)
            def deleteEventSourceMapping(
                request: DeleteEventSourceMappingRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.DeleteEventSourceMappingResponse.ReadOnly
            ] = proxy(DeleteEventSourceMapping, request)
            def getFunctionEventInvokeConfig(
                request: GetFunctionEventInvokeConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.GetFunctionEventInvokeConfigResponse.ReadOnly
            ] = proxy(GetFunctionEventInvokeConfig, request)
            def updateFunctionCode(request: UpdateFunctionCodeRequest): IO[
              AwsError,
              zio.aws.lambda.model.UpdateFunctionCodeResponse.ReadOnly
            ] = proxy(UpdateFunctionCode, request)
            def addLayerVersionPermission(
                request: AddLayerVersionPermissionRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.AddLayerVersionPermissionResponse.ReadOnly
            ] = proxy(AddLayerVersionPermission, request)
            def listFunctionsByCodeSigningConfig(
                request: ListFunctionsByCodeSigningConfigRequest
            ): ZStream[Any, AwsError, FunctionArn] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListFunctionsByCodeSigningConfig, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listFunctionsByCodeSigningConfigPaginated(
                request: ListFunctionsByCodeSigningConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse.ReadOnly
            ] = proxy(ListFunctionsByCodeSigningConfigPaginated, request)
            def invoke(
                request: InvokeRequest
            ): IO[AwsError, zio.aws.lambda.model.InvokeResponse.ReadOnly] =
              proxy(Invoke, request)
            def listTags(
                request: ListTagsRequest
            ): IO[AwsError, zio.aws.lambda.model.ListTagsResponse.ReadOnly] =
              proxy(ListTags, request)
            def publishLayerVersion(request: PublishLayerVersionRequest): IO[
              AwsError,
              zio.aws.lambda.model.PublishLayerVersionResponse.ReadOnly
            ] = proxy(PublishLayerVersion, request)
            def getCodeSigningConfig(request: GetCodeSigningConfigRequest): IO[
              AwsError,
              zio.aws.lambda.model.GetCodeSigningConfigResponse.ReadOnly
            ] = proxy(GetCodeSigningConfig, request)
            def listFunctionEventInvokeConfigs(
                request: ListFunctionEventInvokeConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFunctionEventInvokeConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFunctionEventInvokeConfigsPaginated(
                request: ListFunctionEventInvokeConfigsRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse.ReadOnly
            ] = proxy(ListFunctionEventInvokeConfigsPaginated, request)
            def listLayers(request: ListLayersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.lambda.model.LayersListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLayers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLayersPaginated(
                request: ListLayersRequest
            ): IO[AwsError, zio.aws.lambda.model.ListLayersResponse.ReadOnly] =
              proxy(ListLayersPaginated, request)
            def listFunctionUrlConfigs(
                request: ListFunctionUrlConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lambda.model.FunctionUrlConfig.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFunctionUrlConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFunctionUrlConfigsPaginated(
                request: ListFunctionUrlConfigsRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.ListFunctionUrlConfigsResponse.ReadOnly
            ] = proxy(ListFunctionUrlConfigsPaginated, request)
            def getEventSourceMapping(
                request: GetEventSourceMappingRequest
            ): IO[AwsError, ReadOnly] = proxy(GetEventSourceMapping, request)
            def removeLayerVersionPermission(
                request: RemoveLayerVersionPermissionRequest
            ): IO[AwsError, Unit] = proxy(RemoveLayerVersionPermission, request)
            def updateFunctionEventInvokeConfig(
                request: UpdateFunctionEventInvokeConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.UpdateFunctionEventInvokeConfigResponse.ReadOnly
            ] = proxy(UpdateFunctionEventInvokeConfig, request)
            def createFunctionUrlConfig(
                request: CreateFunctionUrlConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.CreateFunctionUrlConfigResponse.ReadOnly
            ] = proxy(CreateFunctionUrlConfig, request)
            def deleteFunctionEventInvokeConfig(
                request: DeleteFunctionEventInvokeConfigRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteFunctionEventInvokeConfig, request)
            def deleteCodeSigningConfig(
                request: DeleteCodeSigningConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.DeleteCodeSigningConfigResponse.ReadOnly
            ] = proxy(DeleteCodeSigningConfig, request)
            def deleteFunction(
                request: DeleteFunctionRequest
            ): IO[AwsError, Unit] = proxy(DeleteFunction, request)
            def putProvisionedConcurrencyConfig(
                request: PutProvisionedConcurrencyConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.PutProvisionedConcurrencyConfigResponse.ReadOnly
            ] = proxy(PutProvisionedConcurrencyConfig, request)
            def deleteProvisionedConcurrencyConfig(
                request: DeleteProvisionedConcurrencyConfigRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteProvisionedConcurrencyConfig, request)
            def deleteFunctionUrlConfig(
                request: DeleteFunctionUrlConfigRequest
            ): IO[AwsError, Unit] = proxy(DeleteFunctionUrlConfig, request)
            def listAliases(request: ListAliasesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.lambda.model.AliasConfiguration.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAliases, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAliasesPaginated(
                request: ListAliasesRequest
            ): IO[AwsError, zio.aws.lambda.model.ListAliasesResponse.ReadOnly] =
              proxy(ListAliasesPaginated, request)
            def deleteLayerVersion(
                request: DeleteLayerVersionRequest
            ): IO[AwsError, Unit] = proxy(DeleteLayerVersion, request)
            def listProvisionedConcurrencyConfigs(
                request: ListProvisionedConcurrencyConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProvisionedConcurrencyConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProvisionedConcurrencyConfigsPaginated(
                request: ListProvisionedConcurrencyConfigsRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse.ReadOnly
            ] = proxy(ListProvisionedConcurrencyConfigsPaginated, request)
            def putFunctionConcurrency(
                request: PutFunctionConcurrencyRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.PutFunctionConcurrencyResponse.ReadOnly
            ] = proxy(PutFunctionConcurrency, request)
            def addPermission(request: AddPermissionRequest): IO[
              AwsError,
              zio.aws.lambda.model.AddPermissionResponse.ReadOnly
            ] = proxy(AddPermission, request)
            def getProvisionedConcurrencyConfig(
                request: GetProvisionedConcurrencyConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.GetProvisionedConcurrencyConfigResponse.ReadOnly
            ] = proxy(GetProvisionedConcurrencyConfig, request)
            def updateFunctionConfiguration(
                request: UpdateFunctionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.UpdateFunctionConfigurationResponse.ReadOnly
            ] = proxy(UpdateFunctionConfiguration, request)
            def listVersionsByFunction(
                request: ListVersionsByFunctionRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lambda.model.FunctionConfiguration.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVersionsByFunction, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVersionsByFunctionPaginated(
                request: ListVersionsByFunctionRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.ListVersionsByFunctionResponse.ReadOnly
            ] = proxy(ListVersionsByFunctionPaginated, request)
            def updateAlias(
                request: UpdateAliasRequest
            ): IO[AwsError, zio.aws.lambda.model.UpdateAliasResponse.ReadOnly] =
              proxy(UpdateAlias, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def createAlias(
                request: CreateAliasRequest
            ): IO[AwsError, zio.aws.lambda.model.CreateAliasResponse.ReadOnly] =
              proxy(CreateAlias, request)
            def getFunctionUrlConfig(request: GetFunctionUrlConfigRequest): IO[
              AwsError,
              zio.aws.lambda.model.GetFunctionUrlConfigResponse.ReadOnly
            ] = proxy(GetFunctionUrlConfig, request)
            def updateFunctionUrlConfig(
                request: UpdateFunctionUrlConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.UpdateFunctionUrlConfigResponse.ReadOnly
            ] = proxy(UpdateFunctionUrlConfig, request)
            def putFunctionEventInvokeConfig(
                request: PutFunctionEventInvokeConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse.ReadOnly
            ] = proxy(PutFunctionEventInvokeConfig, request)
            def removePermission(
                request: RemovePermissionRequest
            ): IO[AwsError, Unit] = proxy(RemovePermission, request)
            def getFunctionConfiguration(
                request: GetFunctionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.GetFunctionConfigurationResponse.ReadOnly
            ] = proxy(GetFunctionConfiguration, request)
            def getFunctionCodeSigningConfig(
                request: GetFunctionCodeSigningConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse.ReadOnly
            ] = proxy(GetFunctionCodeSigningConfig, request)
            def getLayerVersionPolicy(
                request: GetLayerVersionPolicyRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.GetLayerVersionPolicyResponse.ReadOnly
            ] = proxy(GetLayerVersionPolicy, request)
            def listCodeSigningConfigs(
                request: ListCodeSigningConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.lambda.model.CodeSigningConfig.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCodeSigningConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCodeSigningConfigsPaginated(
                request: ListCodeSigningConfigsRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.ListCodeSigningConfigsResponse.ReadOnly
            ] = proxy(ListCodeSigningConfigsPaginated, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def updateCodeSigningConfig(
                request: UpdateCodeSigningConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.UpdateCodeSigningConfigResponse.ReadOnly
            ] = proxy(UpdateCodeSigningConfig, request)
            def deleteAlias(request: DeleteAliasRequest): IO[AwsError, Unit] =
              proxy(DeleteAlias, request)
            def getAlias(
                request: GetAliasRequest
            ): IO[AwsError, zio.aws.lambda.model.GetAliasResponse.ReadOnly] =
              proxy(GetAlias, request)
            def createEventSourceMapping(
                request: CreateEventSourceMappingRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.CreateEventSourceMappingResponse.ReadOnly
            ] = proxy(CreateEventSourceMapping, request)
            def getLayerVersionByArn(request: GetLayerVersionByArnRequest): IO[
              AwsError,
              zio.aws.lambda.model.GetLayerVersionByArnResponse.ReadOnly
            ] = proxy(GetLayerVersionByArn, request)
            def getFunctionConcurrency(
                request: GetFunctionConcurrencyRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly
            ] = proxy(GetFunctionConcurrency, request)
            def listFunctions(request: ListFunctionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.lambda.model.FunctionConfiguration.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFunctions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFunctionsPaginated(request: ListFunctionsRequest): IO[
              AwsError,
              zio.aws.lambda.model.ListFunctionsResponse.ReadOnly
            ] = proxy(ListFunctionsPaginated, request)
            def getPolicy(
                request: GetPolicyRequest
            ): IO[AwsError, zio.aws.lambda.model.GetPolicyResponse.ReadOnly] =
              proxy(GetPolicy, request)
            def listLayerVersions(request: ListLayerVersionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.lambda.model.LayerVersionsListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLayerVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLayerVersionsPaginated(
                request: ListLayerVersionsRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.ListLayerVersionsResponse.ReadOnly
            ] = proxy(ListLayerVersionsPaginated, request)
            def deleteFunctionConcurrency(
                request: DeleteFunctionConcurrencyRequest
            ): IO[AwsError, Unit] = proxy(DeleteFunctionConcurrency, request)
            def createCodeSigningConfig(
                request: CreateCodeSigningConfigRequest
            ): IO[
              AwsError,
              zio.aws.lambda.model.CreateCodeSigningConfigResponse.ReadOnly
            ] = proxy(CreateCodeSigningConfig, request)
            def publishVersion(request: PublishVersionRequest): IO[
              AwsError,
              zio.aws.lambda.model.PublishVersionResponse.ReadOnly
            ] = proxy(PublishVersion, request)
            def getAccountSettings(request: GetAccountSettingsRequest): IO[
              AwsError,
              zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly
            ] = proxy(GetAccountSettings, request)
            def deleteFunctionCodeSigningConfig(
                request: DeleteFunctionCodeSigningConfigRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteFunctionCodeSigningConfig, request)
            def createFunction(request: CreateFunctionRequest): IO[
              AwsError,
              zio.aws.lambda.model.CreateFunctionResponse.ReadOnly
            ] = proxy(CreateFunction, request)
            def getFunction(
                request: GetFunctionRequest
            ): IO[AwsError, zio.aws.lambda.model.GetFunctionResponse.ReadOnly] =
              proxy(GetFunction, request)
          }
        }
      }
    }
  }
}
