package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AllowedPublishers(signingProfileVersionArns: Iterable[Arn]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.AllowedPublishers = {
    import AllowedPublishers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.AllowedPublishers
      .builder()
      .signingProfileVersionArns(signingProfileVersionArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.AllowedPublishers.ReadOnly =
    zio.aws.lambda.model.AllowedPublishers.wrap(buildAwsValue())
}
object AllowedPublishers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.AllowedPublishers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.AllowedPublishers =
      zio.aws.lambda.model.AllowedPublishers(signingProfileVersionArns)
    def signingProfileVersionArns: List[Arn]
    def getSigningProfileVersionArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(signingProfileVersionArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.AllowedPublishers
  ) extends zio.aws.lambda.model.AllowedPublishers.ReadOnly {
    override val signingProfileVersionArns: List[Arn] = impl
      .signingProfileVersionArns()
      .asScala
      .map { item =>
        zio.aws.lambda.model.primitives.Arn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.AllowedPublishers
  ): zio.aws.lambda.model.AllowedPublishers.ReadOnly = new Wrapper(impl)
}
