package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AddPermissionResponse(
    statement: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.AddPermissionResponse = {
    import AddPermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.AddPermissionResponse
      .builder()
      .optionallyWith(statement.map(value => value: java.lang.String))(
        _.statement
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.AddPermissionResponse.ReadOnly =
    zio.aws.lambda.model.AddPermissionResponse.wrap(buildAwsValue())
}
object AddPermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.AddPermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.AddPermissionResponse =
      zio.aws.lambda.model.AddPermissionResponse(statement.map(value => value))
    def statement: Optional[String]
    def getStatement: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statement", statement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.AddPermissionResponse
  ) extends zio.aws.lambda.model.AddPermissionResponse.ReadOnly {
    override val statement: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statement())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.AddPermissionResponse
  ): zio.aws.lambda.model.AddPermissionResponse.ReadOnly = new Wrapper(impl)
}
