package zio.aws.lambda.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  MaximumRetryAttemptsEventSourceMapping,
  BatchSize,
  BisectBatchOnFunctionError,
  Date,
  MaximumBatchingWindowInSeconds,
  Queue,
  Arn,
  ParallelizationFactor,
  FunctionName,
  Enabled,
  Topic,
  TumblingWindowInSeconds,
  MaximumRecordAgeInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateEventSourceMappingRequest(
    eventSourceArn: Optional[Arn] = Optional.Absent,
    functionName: FunctionName,
    enabled: Optional[Enabled] = Optional.Absent,
    batchSize: Optional[BatchSize] = Optional.Absent,
    filterCriteria: Optional[zio.aws.lambda.model.FilterCriteria] =
      Optional.Absent,
    maximumBatchingWindowInSeconds: Optional[MaximumBatchingWindowInSeconds] =
      Optional.Absent,
    parallelizationFactor: Optional[ParallelizationFactor] = Optional.Absent,
    startingPosition: Optional[zio.aws.lambda.model.EventSourcePosition] =
      Optional.Absent,
    startingPositionTimestamp: Optional[Date] = Optional.Absent,
    destinationConfig: Optional[zio.aws.lambda.model.DestinationConfig] =
      Optional.Absent,
    maximumRecordAgeInSeconds: Optional[MaximumRecordAgeInSeconds] =
      Optional.Absent,
    bisectBatchOnFunctionError: Optional[BisectBatchOnFunctionError] =
      Optional.Absent,
    maximumRetryAttempts: Optional[MaximumRetryAttemptsEventSourceMapping] =
      Optional.Absent,
    tumblingWindowInSeconds: Optional[TumblingWindowInSeconds] =
      Optional.Absent,
    topics: Optional[Iterable[Topic]] = Optional.Absent,
    queues: Optional[Iterable[Queue]] = Optional.Absent,
    sourceAccessConfigurations: Optional[
      Iterable[zio.aws.lambda.model.SourceAccessConfiguration]
    ] = Optional.Absent,
    selfManagedEventSource: Optional[
      zio.aws.lambda.model.SelfManagedEventSource
    ] = Optional.Absent,
    functionResponseTypes: Optional[
      Iterable[zio.aws.lambda.model.FunctionResponseType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest = {
    import CreateEventSourceMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest
      .builder()
      .optionallyWith(
        eventSourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventSourceArn)
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(batchSize.map(value => BatchSize.unwrap(value): Integer))(
        _.batchSize
      )
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maximumBatchingWindowInSeconds.map(value =>
          MaximumBatchingWindowInSeconds.unwrap(value): Integer
        )
      )(_.maximumBatchingWindowInSeconds)
      .optionallyWith(
        parallelizationFactor.map(value =>
          ParallelizationFactor.unwrap(value): Integer
        )
      )(_.parallelizationFactor)
      .optionallyWith(startingPosition.map(value => value.unwrap))(
        _.startingPosition
      )
      .optionallyWith(
        startingPositionTimestamp.map(value => Date.unwrap(value): Instant)
      )(_.startingPositionTimestamp)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .optionallyWith(
        maximumRecordAgeInSeconds.map(value =>
          MaximumRecordAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumRecordAgeInSeconds)
      .optionallyWith(
        bisectBatchOnFunctionError.map(value =>
          BisectBatchOnFunctionError.unwrap(value): java.lang.Boolean
        )
      )(_.bisectBatchOnFunctionError)
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttemptsEventSourceMapping.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .optionallyWith(
        tumblingWindowInSeconds.map(value =>
          TumblingWindowInSeconds.unwrap(value): Integer
        )
      )(_.tumblingWindowInSeconds)
      .optionallyWith(
        topics.map(value =>
          value.map { item =>
            Topic.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.topics)
      .optionallyWith(
        queues.map(value =>
          value.map { item =>
            Queue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queues)
      .optionallyWith(
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceAccessConfigurations)
      .optionallyWith(
        selfManagedEventSource.map(value => value.buildAwsValue())
      )(_.selfManagedEventSource)
      .optionallyWith(
        functionResponseTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.functionResponseTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.CreateEventSourceMappingRequest.ReadOnly =
    zio.aws.lambda.model.CreateEventSourceMappingRequest.wrap(buildAwsValue())
}
object CreateEventSourceMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CreateEventSourceMappingRequest =
      zio.aws.lambda.model.CreateEventSourceMappingRequest(
        eventSourceArn.map(value => value),
        functionName,
        enabled.map(value => value),
        batchSize.map(value => value),
        filterCriteria.map(value => value.asEditable),
        maximumBatchingWindowInSeconds.map(value => value),
        parallelizationFactor.map(value => value),
        startingPosition.map(value => value),
        startingPositionTimestamp.map(value => value),
        destinationConfig.map(value => value.asEditable),
        maximumRecordAgeInSeconds.map(value => value),
        bisectBatchOnFunctionError.map(value => value),
        maximumRetryAttempts.map(value => value),
        tumblingWindowInSeconds.map(value => value),
        topics.map(value => value),
        queues.map(value => value),
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        selfManagedEventSource.map(value => value.asEditable),
        functionResponseTypes.map(value => value)
      )
    def eventSourceArn: Optional[Arn]
    def functionName: FunctionName
    def enabled: Optional[Enabled]
    def batchSize: Optional[BatchSize]
    def filterCriteria: Optional[zio.aws.lambda.model.FilterCriteria.ReadOnly]
    def maximumBatchingWindowInSeconds: Optional[MaximumBatchingWindowInSeconds]
    def parallelizationFactor: Optional[ParallelizationFactor]
    def startingPosition: Optional[zio.aws.lambda.model.EventSourcePosition]
    def startingPositionTimestamp: Optional[Date]
    def destinationConfig
        : Optional[zio.aws.lambda.model.DestinationConfig.ReadOnly]
    def maximumRecordAgeInSeconds: Optional[MaximumRecordAgeInSeconds]
    def bisectBatchOnFunctionError: Optional[BisectBatchOnFunctionError]
    def maximumRetryAttempts: Optional[MaximumRetryAttemptsEventSourceMapping]
    def tumblingWindowInSeconds: Optional[TumblingWindowInSeconds]
    def topics: Optional[List[Topic]]
    def queues: Optional[List[Queue]]
    def sourceAccessConfigurations: Optional[
      List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]
    ]
    def selfManagedEventSource
        : Optional[zio.aws.lambda.model.SelfManagedEventSource.ReadOnly]
    def functionResponseTypes
        : Optional[List[zio.aws.lambda.model.FunctionResponseType]]
    def getEventSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getBatchSize: ZIO[Any, AwsError, BatchSize] =
      AwsError.unwrapOptionField("batchSize", batchSize)
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.lambda.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaximumBatchingWindowInSeconds
        : ZIO[Any, AwsError, MaximumBatchingWindowInSeconds] =
      AwsError.unwrapOptionField(
        "maximumBatchingWindowInSeconds",
        maximumBatchingWindowInSeconds
      )
    def getParallelizationFactor: ZIO[Any, AwsError, ParallelizationFactor] =
      AwsError.unwrapOptionField("parallelizationFactor", parallelizationFactor)
    def getStartingPosition
        : ZIO[Any, AwsError, zio.aws.lambda.model.EventSourcePosition] =
      AwsError.unwrapOptionField("startingPosition", startingPosition)
    def getStartingPositionTimestamp: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("startingPositionTimestamp", startingPositionTimestamp)
    def getDestinationConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      AwsError.unwrapOptionField("destinationConfig", destinationConfig)
    def getMaximumRecordAgeInSeconds
        : ZIO[Any, AwsError, MaximumRecordAgeInSeconds] = AwsError
      .unwrapOptionField("maximumRecordAgeInSeconds", maximumRecordAgeInSeconds)
    def getBisectBatchOnFunctionError
        : ZIO[Any, AwsError, BisectBatchOnFunctionError] =
      AwsError.unwrapOptionField(
        "bisectBatchOnFunctionError",
        bisectBatchOnFunctionError
      )
    def getMaximumRetryAttempts
        : ZIO[Any, AwsError, MaximumRetryAttemptsEventSourceMapping] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
    def getTumblingWindowInSeconds
        : ZIO[Any, AwsError, TumblingWindowInSeconds] = AwsError
      .unwrapOptionField("tumblingWindowInSeconds", tumblingWindowInSeconds)
    def getTopics: ZIO[Any, AwsError, List[Topic]] =
      AwsError.unwrapOptionField("topics", topics)
    def getQueues: ZIO[Any, AwsError, List[Queue]] =
      AwsError.unwrapOptionField("queues", queues)
    def getSourceAccessConfigurations: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sourceAccessConfigurations",
      sourceAccessConfigurations
    )
    def getSelfManagedEventSource: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.SelfManagedEventSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedEventSource",
      selfManagedEventSource
    )
    def getFunctionResponseTypes
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.FunctionResponseType]] =
      AwsError.unwrapOptionField("functionResponseTypes", functionResponseTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest
  ) extends zio.aws.lambda.model.CreateEventSourceMappingRequest.ReadOnly {
    override val eventSourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSourceArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.lambda.model.primitives.Enabled(value))
    override val batchSize: Optional[BatchSize] = zio.aws.core.internal
      .optionalFromNullable(impl.batchSize())
      .map(value => zio.aws.lambda.model.primitives.BatchSize(value))
    override val filterCriteria
        : Optional[zio.aws.lambda.model.FilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriteria())
        .map(value => zio.aws.lambda.model.FilterCriteria.wrap(value))
    override val maximumBatchingWindowInSeconds
        : Optional[MaximumBatchingWindowInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumBatchingWindowInSeconds())
      .map(value =>
        zio.aws.lambda.model.primitives.MaximumBatchingWindowInSeconds(value)
      )
    override val parallelizationFactor: Optional[ParallelizationFactor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelizationFactor())
        .map(value =>
          zio.aws.lambda.model.primitives.ParallelizationFactor(value)
        )
    override val startingPosition
        : Optional[zio.aws.lambda.model.EventSourcePosition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startingPosition())
        .map(value => zio.aws.lambda.model.EventSourcePosition.wrap(value))
    override val startingPositionTimestamp: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startingPositionTimestamp())
        .map(value => zio.aws.lambda.model.primitives.Date(value))
    override val destinationConfig
        : Optional[zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationConfig())
        .map(value => zio.aws.lambda.model.DestinationConfig.wrap(value))
    override val maximumRecordAgeInSeconds
        : Optional[MaximumRecordAgeInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumRecordAgeInSeconds())
      .map(value =>
        zio.aws.lambda.model.primitives.MaximumRecordAgeInSeconds(value)
      )
    override val bisectBatchOnFunctionError
        : Optional[BisectBatchOnFunctionError] = zio.aws.core.internal
      .optionalFromNullable(impl.bisectBatchOnFunctionError())
      .map(value =>
        zio.aws.lambda.model.primitives.BisectBatchOnFunctionError(value)
      )
    override val maximumRetryAttempts
        : Optional[MaximumRetryAttemptsEventSourceMapping] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumRetryAttempts())
        .map(value =>
          zio.aws.lambda.model.primitives
            .MaximumRetryAttemptsEventSourceMapping(value)
        )
    override val tumblingWindowInSeconds: Optional[TumblingWindowInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tumblingWindowInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.TumblingWindowInSeconds(value)
        )
    override val topics: Optional[List[Topic]] = zio.aws.core.internal
      .optionalFromNullable(impl.topics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Topic(item)
        }.toList
      )
    override val queues: Optional[List[Queue]] = zio.aws.core.internal
      .optionalFromNullable(impl.queues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Queue(item)
        }.toList
      )
    override val sourceAccessConfigurations: Optional[
      List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceAccessConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.SourceAccessConfiguration.wrap(item)
        }.toList
      )
    override val selfManagedEventSource
        : Optional[zio.aws.lambda.model.SelfManagedEventSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selfManagedEventSource())
        .map(value => zio.aws.lambda.model.SelfManagedEventSource.wrap(value))
    override val functionResponseTypes
        : Optional[List[zio.aws.lambda.model.FunctionResponseType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionResponseTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.FunctionResponseType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest
  ): zio.aws.lambda.model.CreateEventSourceMappingRequest.ReadOnly =
    new Wrapper(impl)
}
