package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  Timestamp,
  NonNegativeInteger,
  PositiveInteger,
  FunctionArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ProvisionedConcurrencyConfigListItem(
    functionArn: Optional[FunctionArn] = Optional.Absent,
    requestedProvisionedConcurrentExecutions: Optional[PositiveInteger] =
      Optional.Absent,
    availableProvisionedConcurrentExecutions: Optional[NonNegativeInteger] =
      Optional.Absent,
    allocatedProvisionedConcurrentExecutions: Optional[NonNegativeInteger] =
      Optional.Absent,
    status: Optional[zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum] =
      Optional.Absent,
    statusReason: Optional[String] = Optional.Absent,
    lastModified: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem = {
    import ProvisionedConcurrencyConfigListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem
      .builder()
      .optionallyWith(
        functionArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.functionArn)
      .optionallyWith(
        requestedProvisionedConcurrentExecutions.map(value =>
          PositiveInteger.unwrap(value): Integer
        )
      )(_.requestedProvisionedConcurrentExecutions)
      .optionallyWith(
        availableProvisionedConcurrentExecutions.map(value =>
          NonNegativeInteger.unwrap(value): Integer
        )
      )(_.availableProvisionedConcurrentExecutions)
      .optionallyWith(
        allocatedProvisionedConcurrentExecutions.map(value =>
          NonNegativeInteger.unwrap(value): Integer
        )
      )(_.allocatedProvisionedConcurrentExecutions)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(
        lastModified.map(value => Timestamp.unwrap(value): java.lang.String)
      )(_.lastModified)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly =
    zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem
      .wrap(buildAwsValue())
}
object ProvisionedConcurrencyConfigListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem =
      zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem(
        functionArn.map(value => value),
        requestedProvisionedConcurrentExecutions.map(value => value),
        availableProvisionedConcurrentExecutions.map(value => value),
        allocatedProvisionedConcurrentExecutions.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        lastModified.map(value => value)
      )
    def functionArn: Optional[FunctionArn]
    def requestedProvisionedConcurrentExecutions: Optional[PositiveInteger]
    def availableProvisionedConcurrentExecutions: Optional[NonNegativeInteger]
    def allocatedProvisionedConcurrentExecutions: Optional[NonNegativeInteger]
    def status: Optional[zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum]
    def statusReason: Optional[String]
    def lastModified: Optional[Timestamp]
    def getFunctionArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getRequestedProvisionedConcurrentExecutions
        : ZIO[Any, AwsError, PositiveInteger] = AwsError.unwrapOptionField(
      "requestedProvisionedConcurrentExecutions",
      requestedProvisionedConcurrentExecutions
    )
    def getAvailableProvisionedConcurrentExecutions
        : ZIO[Any, AwsError, NonNegativeInteger] = AwsError.unwrapOptionField(
      "availableProvisionedConcurrentExecutions",
      availableProvisionedConcurrentExecutions
    )
    def getAllocatedProvisionedConcurrentExecutions
        : ZIO[Any, AwsError, NonNegativeInteger] = AwsError.unwrapOptionField(
      "allocatedProvisionedConcurrentExecutions",
      allocatedProvisionedConcurrentExecutions
    )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getLastModified: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem
  ) extends zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly {
    override val functionArn: Optional[FunctionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.functionArn())
      .map(value => zio.aws.lambda.model.primitives.FunctionArn(value))
    override val requestedProvisionedConcurrentExecutions
        : Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.requestedProvisionedConcurrentExecutions())
      .map(value => zio.aws.lambda.model.primitives.PositiveInteger(value))
    override val availableProvisionedConcurrentExecutions
        : Optional[NonNegativeInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.availableProvisionedConcurrentExecutions())
      .map(value => zio.aws.lambda.model.primitives.NonNegativeInteger(value))
    override val allocatedProvisionedConcurrentExecutions
        : Optional[NonNegativeInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedProvisionedConcurrentExecutions())
      .map(value => zio.aws.lambda.model.primitives.NonNegativeInteger(value))
    override val status
        : Optional[zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum.wrap(value)
        )
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val lastModified: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.lambda.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem
  ): zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly =
    new Wrapper(impl)
}
