package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait Architecture {
  def unwrap: software.amazon.awssdk.services.lambda.model.Architecture
}
object Architecture {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.Architecture
  ): zio.aws.lambda.model.Architecture = value match {
    case software.amazon.awssdk.services.lambda.model.Architecture.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.Architecture.X86_64 =>
      val r = x86_64
      r
    case software.amazon.awssdk.services.lambda.model.Architecture.ARM64 =>
      val r = arm64
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.Architecture {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.Architecture =
      software.amazon.awssdk.services.lambda.model.Architecture.UNKNOWN_TO_SDK_VERSION
  }
  case object x86_64 extends zio.aws.lambda.model.Architecture {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.Architecture =
      software.amazon.awssdk.services.lambda.model.Architecture.X86_64
  }
  case object arm64 extends zio.aws.lambda.model.Architecture {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.Architecture =
      software.amazon.awssdk.services.lambda.model.Architecture.ARM64
  }
}
