package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{FunctionName, CodeSigningConfigArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutFunctionCodeSigningConfigResponse(
    codeSigningConfigArn: CodeSigningConfigArn,
    functionName: FunctionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigResponse = {
    import PutFunctionCodeSigningConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigResponse
      .builder()
      .codeSigningConfigArn(
        CodeSigningConfigArn.unwrap(codeSigningConfigArn): java.lang.String
      )
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse.ReadOnly =
    zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse
      .wrap(buildAwsValue())
}
object PutFunctionCodeSigningConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse =
      zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse(
        codeSigningConfigArn,
        functionName
      )
    def codeSigningConfigArn: CodeSigningConfigArn
    def functionName: FunctionName
    def getCodeSigningConfigArn: ZIO[Any, Nothing, CodeSigningConfigArn] =
      ZIO.succeed(codeSigningConfigArn)
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigResponse
  ) extends zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse.ReadOnly {
    override val codeSigningConfigArn: CodeSigningConfigArn =
      zio.aws.lambda.model.primitives
        .CodeSigningConfigArn(impl.codeSigningConfigArn())
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigResponse
  ): zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse.ReadOnly =
    new Wrapper(impl)
}
