package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FilterCriteria(
    filters: Optional[Iterable[zio.aws.lambda.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.FilterCriteria = {
    import FilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.FilterCriteria
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.FilterCriteria.ReadOnly =
    zio.aws.lambda.model.FilterCriteria.wrap(buildAwsValue())
}
object FilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.FilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.FilterCriteria =
      zio.aws.lambda.model.FilterCriteria(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def filters: Optional[List[zio.aws.lambda.model.Filter.ReadOnly]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.FilterCriteria
  ) extends zio.aws.lambda.model.FilterCriteria.ReadOnly {
    override val filters: Optional[List[zio.aws.lambda.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.FilterCriteria
  ): zio.aws.lambda.model.FilterCriteria.ReadOnly = new Wrapper(impl)
}
