package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.FunctionName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteFunctionConcurrencyRequest(functionName: FunctionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest = {
    import DeleteFunctionConcurrencyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.DeleteFunctionConcurrencyRequest.ReadOnly =
    zio.aws.lambda.model.DeleteFunctionConcurrencyRequest.wrap(buildAwsValue())
}
object DeleteFunctionConcurrencyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.DeleteFunctionConcurrencyRequest =
      zio.aws.lambda.model.DeleteFunctionConcurrencyRequest(functionName)
    def functionName: FunctionName
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest
  ) extends zio.aws.lambda.model.DeleteFunctionConcurrencyRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest
  ): zio.aws.lambda.model.DeleteFunctionConcurrencyRequest.ReadOnly =
    new Wrapper(impl)
}
