package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLayerVersionPolicyResponse(
    policy: Optional[String] = Optional.Absent,
    revisionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse = {
    import GetLayerVersionPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetLayerVersionPolicyResponse.ReadOnly =
    zio.aws.lambda.model.GetLayerVersionPolicyResponse.wrap(buildAwsValue())
}
object GetLayerVersionPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetLayerVersionPolicyResponse =
      zio.aws.lambda.model.GetLayerVersionPolicyResponse(
        policy.map(value => value),
        revisionId.map(value => value)
      )
    def policy: Optional[String]
    def revisionId: Optional[String]
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse
  ) extends zio.aws.lambda.model.GetLayerVersionPolicyResponse.ReadOnly {
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
    override val revisionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse
  ): zio.aws.lambda.model.GetLayerVersionPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
