package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{FunctionUrlQualifier, FunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteFunctionUrlConfigRequest(
    functionName: FunctionName,
    qualifier: Optional[FunctionUrlQualifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigRequest = {
    import DeleteFunctionUrlConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        qualifier.map(value =>
          FunctionUrlQualifier.unwrap(value): java.lang.String
        )
      )(_.qualifier)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.DeleteFunctionUrlConfigRequest.ReadOnly =
    zio.aws.lambda.model.DeleteFunctionUrlConfigRequest.wrap(buildAwsValue())
}
object DeleteFunctionUrlConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.DeleteFunctionUrlConfigRequest =
      zio.aws.lambda.model.DeleteFunctionUrlConfigRequest(
        functionName,
        qualifier.map(value => value)
      )
    def functionName: FunctionName
    def qualifier: Optional[FunctionUrlQualifier]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, FunctionUrlQualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigRequest
  ) extends zio.aws.lambda.model.DeleteFunctionUrlConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Optional[FunctionUrlQualifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualifier())
        .map(value =>
          zio.aws.lambda.model.primitives.FunctionUrlQualifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigRequest
  ): zio.aws.lambda.model.DeleteFunctionUrlConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
