package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait TracingMode {
  def unwrap: software.amazon.awssdk.services.lambda.model.TracingMode
}
object TracingMode {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.TracingMode
  ): zio.aws.lambda.model.TracingMode = value match {
    case software.amazon.awssdk.services.lambda.model.TracingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.TracingMode.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.lambda.model.TracingMode.PASS_THROUGH =>
      val r = PassThrough
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.TracingMode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.TracingMode =
      software.amazon.awssdk.services.lambda.model.TracingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.lambda.model.TracingMode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.TracingMode =
      software.amazon.awssdk.services.lambda.model.TracingMode.ACTIVE
  }
  case object PassThrough extends zio.aws.lambda.model.TracingMode {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.TracingMode =
      software.amazon.awssdk.services.lambda.model.TracingMode.PASS_THROUGH
  }
}
