package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLayerVersionsResponse(
    nextMarker: Optional[String] = Optional.Absent,
    layerVersions: Optional[
      Iterable[zio.aws.lambda.model.LayerVersionsListItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse = {
    import ListLayerVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        layerVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.layerVersions)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListLayerVersionsResponse.ReadOnly =
    zio.aws.lambda.model.ListLayerVersionsResponse.wrap(buildAwsValue())
}
object ListLayerVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListLayerVersionsResponse =
      zio.aws.lambda.model.ListLayerVersionsResponse(
        nextMarker.map(value => value),
        layerVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[String]
    def layerVersions
        : Optional[List[zio.aws.lambda.model.LayerVersionsListItem.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLayerVersions: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.LayerVersionsListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("layerVersions", layerVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse
  ) extends zio.aws.lambda.model.ListLayerVersionsResponse.ReadOnly {
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
    override val layerVersions
        : Optional[List[zio.aws.lambda.model.LayerVersionsListItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layerVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.LayerVersionsListItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse
  ): zio.aws.lambda.model.ListLayerVersionsResponse.ReadOnly = new Wrapper(impl)
}
