package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  EnvironmentVariableValue,
  EnvironmentVariableName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Environment(
    variables: Optional[
      Map[EnvironmentVariableName, EnvironmentVariableValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.Environment = {
    import Environment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.Environment
      .builder()
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentVariableName
                .unwrap(key): java.lang.String) -> (EnvironmentVariableValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.Environment.ReadOnly =
    zio.aws.lambda.model.Environment.wrap(buildAwsValue())
}
object Environment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.Environment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.Environment =
      zio.aws.lambda.model.Environment(variables.map(value => value))
    def variables
        : Optional[Map[EnvironmentVariableName, EnvironmentVariableValue]]
    def getVariables: ZIO[Any, AwsError, Map[
      EnvironmentVariableName,
      EnvironmentVariableValue
    ]] = AwsError.unwrapOptionField("variables", variables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.Environment
  ) extends zio.aws.lambda.model.Environment.ReadOnly {
    override val variables
        : Optional[Map[EnvironmentVariableName, EnvironmentVariableValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lambda.model.primitives
                .EnvironmentVariableName(key) -> zio.aws.lambda.model.primitives
                .EnvironmentVariableValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.Environment
  ): zio.aws.lambda.model.Environment.ReadOnly = new Wrapper(impl)
}
