package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{FunctionName, CodeSigningConfigArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutFunctionCodeSigningConfigRequest(
    codeSigningConfigArn: CodeSigningConfigArn,
    functionName: FunctionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest = {
    import PutFunctionCodeSigningConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest
      .builder()
      .codeSigningConfigArn(
        CodeSigningConfigArn.unwrap(codeSigningConfigArn): java.lang.String
      )
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.PutFunctionCodeSigningConfigRequest.ReadOnly =
    zio.aws.lambda.model.PutFunctionCodeSigningConfigRequest
      .wrap(buildAwsValue())
}
object PutFunctionCodeSigningConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PutFunctionCodeSigningConfigRequest =
      zio.aws.lambda.model
        .PutFunctionCodeSigningConfigRequest(codeSigningConfigArn, functionName)
    def codeSigningConfigArn: CodeSigningConfigArn
    def functionName: FunctionName
    def getCodeSigningConfigArn: ZIO[Any, Nothing, CodeSigningConfigArn] =
      ZIO.succeed(codeSigningConfigArn)
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest
  ) extends zio.aws.lambda.model.PutFunctionCodeSigningConfigRequest.ReadOnly {
    override val codeSigningConfigArn: CodeSigningConfigArn =
      zio.aws.lambda.model.primitives
        .CodeSigningConfigArn(impl.codeSigningConfigArn())
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest
  ): zio.aws.lambda.model.PutFunctionCodeSigningConfigRequest.ReadOnly =
    new Wrapper(impl)
}
