package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  LicenseInfo,
  LayerVersionNumber,
  Timestamp,
  LayerVersionArn,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LayerVersionsListItem(
    layerVersionArn: Optional[LayerVersionArn] = Optional.Absent,
    version: Optional[LayerVersionNumber] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    createdDate: Optional[Timestamp] = Optional.Absent,
    compatibleRuntimes: Optional[Iterable[zio.aws.lambda.model.Runtime]] =
      Optional.Absent,
    licenseInfo: Optional[LicenseInfo] = Optional.Absent,
    compatibleArchitectures: Optional[
      Iterable[zio.aws.lambda.model.Architecture]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.LayerVersionsListItem = {
    import LayerVersionsListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.LayerVersionsListItem
      .builder()
      .optionallyWith(
        layerVersionArn.map(value =>
          LayerVersionArn.unwrap(value): java.lang.String
        )
      )(_.layerVersionArn)
      .optionallyWith(
        version.map(value => LayerVersionNumber.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        compatibleRuntimes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.compatibleRuntimesWithStrings)
      .optionallyWith(
        licenseInfo.map(value => LicenseInfo.unwrap(value): java.lang.String)
      )(_.licenseInfo)
      .optionallyWith(
        compatibleArchitectures.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.compatibleArchitecturesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.LayerVersionsListItem.ReadOnly =
    zio.aws.lambda.model.LayerVersionsListItem.wrap(buildAwsValue())
}
object LayerVersionsListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.LayerVersionsListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.LayerVersionsListItem =
      zio.aws.lambda.model.LayerVersionsListItem(
        layerVersionArn.map(value => value),
        version.map(value => value),
        description.map(value => value),
        createdDate.map(value => value),
        compatibleRuntimes.map(value => value),
        licenseInfo.map(value => value),
        compatibleArchitectures.map(value => value)
      )
    def layerVersionArn: Optional[LayerVersionArn]
    def version: Optional[LayerVersionNumber]
    def description: Optional[Description]
    def createdDate: Optional[Timestamp]
    def compatibleRuntimes: Optional[List[zio.aws.lambda.model.Runtime]]
    def licenseInfo: Optional[LicenseInfo]
    def compatibleArchitectures
        : Optional[List[zio.aws.lambda.model.Architecture]]
    def getLayerVersionArn: ZIO[Any, AwsError, LayerVersionArn] =
      AwsError.unwrapOptionField("layerVersionArn", layerVersionArn)
    def getVersion: ZIO[Any, AwsError, LayerVersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getCompatibleRuntimes
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Runtime]] =
      AwsError.unwrapOptionField("compatibleRuntimes", compatibleRuntimes)
    def getLicenseInfo: ZIO[Any, AwsError, LicenseInfo] =
      AwsError.unwrapOptionField("licenseInfo", licenseInfo)
    def getCompatibleArchitectures
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.Architecture]] = AwsError
      .unwrapOptionField("compatibleArchitectures", compatibleArchitectures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.LayerVersionsListItem
  ) extends zio.aws.lambda.model.LayerVersionsListItem.ReadOnly {
    override val layerVersionArn: Optional[LayerVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layerVersionArn())
        .map(value => zio.aws.lambda.model.primitives.LayerVersionArn(value))
    override val version: Optional[LayerVersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.lambda.model.primitives.LayerVersionNumber(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val createdDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.lambda.model.primitives.Timestamp(value))
    override val compatibleRuntimes
        : Optional[List[zio.aws.lambda.model.Runtime]] = zio.aws.core.internal
      .optionalFromNullable(impl.compatibleRuntimes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.Runtime.wrap(item)
        }.toList
      )
    override val licenseInfo: Optional[LicenseInfo] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseInfo())
      .map(value => zio.aws.lambda.model.primitives.LicenseInfo(value))
    override val compatibleArchitectures
        : Optional[List[zio.aws.lambda.model.Architecture]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compatibleArchitectures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.Architecture.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.LayerVersionsListItem
  ): zio.aws.lambda.model.LayerVersionsListItem.ReadOnly = new Wrapper(impl)
}
