package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LayerVersionContentOutput(
    location: Optional[String] = Optional.Absent,
    codeSha256: Optional[String] = Optional.Absent,
    codeSize: Optional[Long] = Optional.Absent,
    signingProfileVersionArn: Optional[String] = Optional.Absent,
    signingJobArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.LayerVersionContentOutput = {
    import LayerVersionContentOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.LayerVersionContentOutput
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(codeSha256.map(value => value: java.lang.String))(
        _.codeSha256
      )
      .optionallyWith(codeSize.map(value => value: java.lang.Long))(_.codeSize)
      .optionallyWith(
        signingProfileVersionArn.map(value => value: java.lang.String)
      )(_.signingProfileVersionArn)
      .optionallyWith(signingJobArn.map(value => value: java.lang.String))(
        _.signingJobArn
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.LayerVersionContentOutput.ReadOnly =
    zio.aws.lambda.model.LayerVersionContentOutput.wrap(buildAwsValue())
}
object LayerVersionContentOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.LayerVersionContentOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.LayerVersionContentOutput =
      zio.aws.lambda.model.LayerVersionContentOutput(
        location.map(value => value),
        codeSha256.map(value => value),
        codeSize.map(value => value),
        signingProfileVersionArn.map(value => value),
        signingJobArn.map(value => value)
      )
    def location: Optional[String]
    def codeSha256: Optional[String]
    def codeSize: Optional[Long]
    def signingProfileVersionArn: Optional[String]
    def signingJobArn: Optional[String]
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getCodeSha256: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codeSha256", codeSha256)
    def getCodeSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("codeSize", codeSize)
    def getSigningProfileVersionArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("signingProfileVersionArn", signingProfileVersionArn)
    def getSigningJobArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signingJobArn", signingJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.LayerVersionContentOutput
  ) extends zio.aws.lambda.model.LayerVersionContentOutput.ReadOnly {
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val codeSha256: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.codeSha256())
      .map(value => value: String)
    override val codeSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.codeSize())
      .map(value => value: Long)
    override val signingProfileVersionArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingProfileVersionArn())
        .map(value => value: String)
    override val signingJobArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signingJobArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.LayerVersionContentOutput
  ): zio.aws.lambda.model.LayerVersionContentOutput.ReadOnly = new Wrapper(impl)
}
