package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.DestinationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OnFailure(
    destination: Optional[DestinationArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.OnFailure = {
    import OnFailure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.OnFailure
      .builder()
      .optionallyWith(
        destination.map(value => DestinationArn.unwrap(value): java.lang.String)
      )(_.destination)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.OnFailure.ReadOnly =
    zio.aws.lambda.model.OnFailure.wrap(buildAwsValue())
}
object OnFailure {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lambda.model.OnFailure] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.OnFailure =
      zio.aws.lambda.model.OnFailure(destination.map(value => value))
    def destination: Optional[DestinationArn]
    def getDestination: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.OnFailure
  ) extends zio.aws.lambda.model.OnFailure.ReadOnly {
    override val destination: Optional[DestinationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.lambda.model.primitives.DestinationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.OnFailure
  ): zio.aws.lambda.model.OnFailure.ReadOnly = new Wrapper(impl)
}
