package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.WorkingDirectory
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImageConfig(
    entryPoint: Optional[Iterable[String]] = Optional.Absent,
    command: Optional[Iterable[String]] = Optional.Absent,
    workingDirectory: Optional[WorkingDirectory] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ImageConfig = {
    import ImageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ImageConfig
      .builder()
      .optionallyWith(
        entryPoint.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.entryPoint)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        workingDirectory.map(value =>
          WorkingDirectory.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ImageConfig.ReadOnly =
    zio.aws.lambda.model.ImageConfig.wrap(buildAwsValue())
}
object ImageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ImageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ImageConfig =
      zio.aws.lambda.model.ImageConfig(
        entryPoint.map(value => value),
        command.map(value => value),
        workingDirectory.map(value => value)
      )
    def entryPoint: Optional[List[String]]
    def command: Optional[List[String]]
    def workingDirectory: Optional[WorkingDirectory]
    def getEntryPoint: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("entryPoint", entryPoint)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getWorkingDirectory: ZIO[Any, AwsError, WorkingDirectory] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ImageConfig
  ) extends zio.aws.lambda.model.ImageConfig.ReadOnly {
    override val entryPoint: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.entryPoint())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val command: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val workingDirectory: Optional[WorkingDirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workingDirectory())
        .map(value => zio.aws.lambda.model.primitives.WorkingDirectory(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ImageConfig
  ): zio.aws.lambda.model.ImageConfig.ReadOnly = new Wrapper(impl)
}
