package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodeSigningPolicies(
    untrustedArtifactOnDeployment: Optional[
      zio.aws.lambda.model.CodeSigningPolicy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CodeSigningPolicies = {
    import CodeSigningPolicies.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CodeSigningPolicies
      .builder()
      .optionallyWith(untrustedArtifactOnDeployment.map(value => value.unwrap))(
        _.untrustedArtifactOnDeployment
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.CodeSigningPolicies.ReadOnly =
    zio.aws.lambda.model.CodeSigningPolicies.wrap(buildAwsValue())
}
object CodeSigningPolicies {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CodeSigningPolicies
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CodeSigningPolicies =
      zio.aws.lambda.model
        .CodeSigningPolicies(untrustedArtifactOnDeployment.map(value => value))
    def untrustedArtifactOnDeployment
        : Optional[zio.aws.lambda.model.CodeSigningPolicy]
    def getUntrustedArtifactOnDeployment
        : ZIO[Any, AwsError, zio.aws.lambda.model.CodeSigningPolicy] =
      AwsError.unwrapOptionField(
        "untrustedArtifactOnDeployment",
        untrustedArtifactOnDeployment
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CodeSigningPolicies
  ) extends zio.aws.lambda.model.CodeSigningPolicies.ReadOnly {
    override val untrustedArtifactOnDeployment
        : Optional[zio.aws.lambda.model.CodeSigningPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.untrustedArtifactOnDeployment())
        .map(value => zio.aws.lambda.model.CodeSigningPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CodeSigningPolicies
  ): zio.aws.lambda.model.CodeSigningPolicies.ReadOnly = new Wrapper(impl)
}
