package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{TagValue, TagKey, FunctionArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resource: FunctionArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.TagResourceRequest
      .builder()
      .resource(FunctionArn.unwrap(resource): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.TagResourceRequest.ReadOnly =
    zio.aws.lambda.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.TagResourceRequest =
      zio.aws.lambda.model.TagResourceRequest(resource, tags)
    def resource: FunctionArn
    def tags: Map[TagKey, TagValue]
    def getResource: ZIO[Any, Nothing, FunctionArn] = ZIO.succeed(resource)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.TagResourceRequest
  ) extends zio.aws.lambda.model.TagResourceRequest.ReadOnly {
    override val resource: FunctionArn =
      zio.aws.lambda.model.primitives.FunctionArn(impl.resource())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.lambda.model.primitives
          .TagKey(key) -> zio.aws.lambda.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.TagResourceRequest
  ): zio.aws.lambda.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
