package zio.aws.lambda
import zio.aws.lambda.model.GetEventSourceMappingResponse.ReadOnly
import zio.aws.lambda.model.{
  GetProvisionedConcurrencyConfigRequest,
  GetLayerVersionRequest,
  GetFunctionConfigurationRequest,
  PutFunctionEventInvokeConfigRequest,
  GetFunctionCodeSigningConfigRequest,
  AddLayerVersionPermissionRequest,
  InvokeRequest,
  ListLayerVersionsRequest,
  PutFunctionConcurrencyRequest,
  GetCodeSigningConfigRequest,
  DeleteLayerVersionRequest,
  PublishVersionRequest,
  DeleteCodeSigningConfigRequest,
  DeleteProvisionedConcurrencyConfigRequest,
  UpdateAliasRequest,
  GetFunctionRequest,
  UpdateFunctionConfigurationRequest,
  ListTagsRequest,
  CreateAliasRequest,
  DeleteFunctionRequest,
  ListLayersRequest,
  ListVersionsByFunctionRequest,
  ListFunctionsByCodeSigningConfigRequest,
  DeleteAliasRequest,
  DeleteFunctionCodeSigningConfigRequest,
  ListAliasesRequest,
  PutProvisionedConcurrencyConfigRequest,
  GetFunctionEventInvokeConfigRequest,
  DeleteFunctionConcurrencyRequest,
  DeleteEventSourceMappingRequest,
  UpdateFunctionEventInvokeConfigRequest,
  ListCodeSigningConfigsRequest,
  DeleteFunctionEventInvokeConfigRequest,
  CreateCodeSigningConfigRequest,
  UpdateFunctionCodeRequest,
  CreateEventSourceMappingRequest,
  ListFunctionEventInvokeConfigsRequest,
  CreateFunctionRequest,
  GetPolicyRequest,
  ListEventSourceMappingsRequest,
  ListFunctionsRequest,
  UntagResourceRequest,
  ListProvisionedConcurrencyConfigsRequest,
  UpdateEventSourceMappingRequest,
  GetFunctionConcurrencyRequest,
  UpdateCodeSigningConfigRequest,
  GetLayerVersionPolicyRequest,
  RemoveLayerVersionPermissionRequest,
  PublishLayerVersionRequest,
  AddPermissionRequest,
  RemovePermissionRequest,
  GetEventSourceMappingRequest,
  GetAccountSettingsRequest,
  TagResourceRequest,
  GetAliasRequest,
  PutFunctionCodeSigningConfigRequest,
  GetLayerVersionByArnRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.lambda.{
  LambdaAsyncClientBuilder,
  LambdaAsyncClient
}
import software.amazon.awssdk.services.lambda.paginators.{
  ListCodeSigningConfigsPublisher,
  ListLayerVersionsPublisher,
  ListLayersPublisher,
  ListProvisionedConcurrencyConfigsPublisher,
  ListFunctionEventInvokeConfigsPublisher,
  ListFunctionsByCodeSigningConfigPublisher,
  ListVersionsByFunctionPublisher,
  ListEventSourceMappingsPublisher,
  ListAliasesPublisher,
  ListFunctionsPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.lambda.model.{
  UpdateAliasResponse,
  PutFunctionEventInvokeConfigResponse,
  ListVersionsByFunctionResponse,
  GetLayerVersionPolicyResponse,
  DeleteFunctionEventInvokeConfigResponse,
  GetFunctionConfigurationResponse,
  GetFunctionEventInvokeConfigResponse,
  FunctionConfiguration,
  FunctionEventInvokeConfig,
  EventSourceMappingConfiguration,
  ListLayersResponse,
  GetFunctionCodeSigningConfigResponse,
  DeleteAliasResponse,
  UpdateFunctionConfigurationResponse,
  RemovePermissionResponse,
  PutProvisionedConcurrencyConfigResponse,
  UpdateFunctionEventInvokeConfigResponse,
  UpdateCodeSigningConfigResponse,
  ProvisionedConcurrencyConfigListItem,
  CreateAliasResponse,
  AliasConfiguration,
  PublishVersionResponse,
  ListFunctionsResponse,
  ListFunctionsByCodeSigningConfigResponse,
  ListEventSourceMappingsResponse,
  AddLayerVersionPermissionResponse,
  UntagResourceResponse,
  GetFunctionResponse,
  GetAliasResponse,
  DeleteLayerVersionResponse,
  GetPolicyResponse,
  InvokeResponse,
  PublishLayerVersionResponse,
  AddPermissionResponse,
  ListFunctionEventInvokeConfigsResponse,
  UpdateFunctionCodeResponse,
  LayerVersionsListItem,
  CreateCodeSigningConfigResponse,
  GetEventSourceMappingResponse,
  GetFunctionConcurrencyResponse,
  DeleteFunctionCodeSigningConfigResponse,
  PutFunctionConcurrencyResponse,
  GetLayerVersionResponse,
  GetAccountSettingsResponse,
  CodeSigningConfig,
  GetCodeSigningConfigResponse,
  CreateFunctionResponse,
  DeleteProvisionedConcurrencyConfigResponse,
  DeleteFunctionConcurrencyResponse,
  PutFunctionCodeSigningConfigResponse,
  CreateEventSourceMappingResponse,
  UpdateEventSourceMappingResponse,
  ListAliasesResponse,
  RemoveLayerVersionPermissionResponse,
  DeleteFunctionResponse,
  DeleteEventSourceMappingResponse,
  DeleteCodeSigningConfigResponse,
  TagResourceResponse,
  LayersListItem,
  ListProvisionedConcurrencyConfigsResponse,
  GetLayerVersionByArnResponse,
  ListTagsResponse,
  ListCodeSigningConfigsResponse,
  ListLayerVersionsResponse,
  GetProvisionedConcurrencyConfigResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.lambda.model.primitives.FunctionArn
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Lambda extends AspectSupport[Lambda] {
  val api: LambdaAsyncClient
  def listEventSourceMappings(request: ListEventSourceMappingsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly
  ]
  def listEventSourceMappingsPaginated(
      request: ListEventSourceMappingsRequest
  ): IO[AwsError, zio.aws.lambda.model.ListEventSourceMappingsResponse.ReadOnly]
  def getLayerVersion(
      request: GetLayerVersionRequest
  ): IO[AwsError, zio.aws.lambda.model.GetLayerVersionResponse.ReadOnly]
  def putFunctionCodeSigningConfig(
      request: PutFunctionCodeSigningConfigRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse.ReadOnly
  ]
  def updateEventSourceMapping(request: UpdateEventSourceMappingRequest): IO[
    AwsError,
    zio.aws.lambda.model.UpdateEventSourceMappingResponse.ReadOnly
  ]
  def deleteEventSourceMapping(request: DeleteEventSourceMappingRequest): IO[
    AwsError,
    zio.aws.lambda.model.DeleteEventSourceMappingResponse.ReadOnly
  ]
  def getFunctionEventInvokeConfig(
      request: GetFunctionEventInvokeConfigRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.GetFunctionEventInvokeConfigResponse.ReadOnly
  ]
  def updateFunctionCode(
      request: UpdateFunctionCodeRequest
  ): IO[AwsError, zio.aws.lambda.model.UpdateFunctionCodeResponse.ReadOnly]
  def addLayerVersionPermission(request: AddLayerVersionPermissionRequest): IO[
    AwsError,
    zio.aws.lambda.model.AddLayerVersionPermissionResponse.ReadOnly
  ]
  def listFunctionsByCodeSigningConfig(
      request: ListFunctionsByCodeSigningConfigRequest
  ): ZStream[Any, AwsError, FunctionArn]
  def listFunctionsByCodeSigningConfigPaginated(
      request: ListFunctionsByCodeSigningConfigRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse.ReadOnly
  ]
  def invoke(
      request: InvokeRequest
  ): IO[AwsError, zio.aws.lambda.model.InvokeResponse.ReadOnly]
  def listTags(
      request: ListTagsRequest
  ): IO[AwsError, zio.aws.lambda.model.ListTagsResponse.ReadOnly]
  def publishLayerVersion(
      request: PublishLayerVersionRequest
  ): IO[AwsError, zio.aws.lambda.model.PublishLayerVersionResponse.ReadOnly]
  def getCodeSigningConfig(
      request: GetCodeSigningConfigRequest
  ): IO[AwsError, zio.aws.lambda.model.GetCodeSigningConfigResponse.ReadOnly]
  def listFunctionEventInvokeConfigs(
      request: ListFunctionEventInvokeConfigsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly
  ]
  def listFunctionEventInvokeConfigsPaginated(
      request: ListFunctionEventInvokeConfigsRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse.ReadOnly
  ]
  def listLayers(
      request: ListLayersRequest
  ): ZStream[Any, AwsError, zio.aws.lambda.model.LayersListItem.ReadOnly]
  def listLayersPaginated(
      request: ListLayersRequest
  ): IO[AwsError, zio.aws.lambda.model.ListLayersResponse.ReadOnly]
  def getEventSourceMapping(
      request: GetEventSourceMappingRequest
  ): IO[AwsError, ReadOnly]
  def removeLayerVersionPermission(
      request: RemoveLayerVersionPermissionRequest
  ): IO[AwsError, Unit]
  def updateFunctionEventInvokeConfig(
      request: UpdateFunctionEventInvokeConfigRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.UpdateFunctionEventInvokeConfigResponse.ReadOnly
  ]
  def deleteFunctionEventInvokeConfig(
      request: DeleteFunctionEventInvokeConfigRequest
  ): IO[AwsError, Unit]
  def deleteCodeSigningConfig(
      request: DeleteCodeSigningConfigRequest
  ): IO[AwsError, zio.aws.lambda.model.DeleteCodeSigningConfigResponse.ReadOnly]
  def deleteFunction(request: DeleteFunctionRequest): IO[AwsError, Unit]
  def putProvisionedConcurrencyConfig(
      request: PutProvisionedConcurrencyConfigRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.PutProvisionedConcurrencyConfigResponse.ReadOnly
  ]
  def deleteProvisionedConcurrencyConfig(
      request: DeleteProvisionedConcurrencyConfigRequest
  ): IO[AwsError, Unit]
  def listAliases(
      request: ListAliasesRequest
  ): ZStream[Any, AwsError, zio.aws.lambda.model.AliasConfiguration.ReadOnly]
  def listAliasesPaginated(
      request: ListAliasesRequest
  ): IO[AwsError, zio.aws.lambda.model.ListAliasesResponse.ReadOnly]
  def deleteLayerVersion(request: DeleteLayerVersionRequest): IO[AwsError, Unit]
  def listProvisionedConcurrencyConfigs(
      request: ListProvisionedConcurrencyConfigsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly
  ]
  def listProvisionedConcurrencyConfigsPaginated(
      request: ListProvisionedConcurrencyConfigsRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse.ReadOnly
  ]
  def putFunctionConcurrency(
      request: PutFunctionConcurrencyRequest
  ): IO[AwsError, zio.aws.lambda.model.PutFunctionConcurrencyResponse.ReadOnly]
  def addPermission(
      request: AddPermissionRequest
  ): IO[AwsError, zio.aws.lambda.model.AddPermissionResponse.ReadOnly]
  def getProvisionedConcurrencyConfig(
      request: GetProvisionedConcurrencyConfigRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.GetProvisionedConcurrencyConfigResponse.ReadOnly
  ]
  def updateFunctionConfiguration(
      request: UpdateFunctionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.UpdateFunctionConfigurationResponse.ReadOnly
  ]
  def listVersionsByFunction(
      request: ListVersionsByFunctionRequest
  ): ZStream[Any, AwsError, zio.aws.lambda.model.FunctionConfiguration.ReadOnly]
  def listVersionsByFunctionPaginated(
      request: ListVersionsByFunctionRequest
  ): IO[AwsError, zio.aws.lambda.model.ListVersionsByFunctionResponse.ReadOnly]
  def updateAlias(
      request: UpdateAliasRequest
  ): IO[AwsError, zio.aws.lambda.model.UpdateAliasResponse.ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def createAlias(
      request: CreateAliasRequest
  ): IO[AwsError, zio.aws.lambda.model.CreateAliasResponse.ReadOnly]
  def putFunctionEventInvokeConfig(
      request: PutFunctionEventInvokeConfigRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse.ReadOnly
  ]
  def removePermission(request: RemovePermissionRequest): IO[AwsError, Unit]
  def getFunctionConfiguration(request: GetFunctionConfigurationRequest): IO[
    AwsError,
    zio.aws.lambda.model.GetFunctionConfigurationResponse.ReadOnly
  ]
  def getFunctionCodeSigningConfig(
      request: GetFunctionCodeSigningConfigRequest
  ): IO[
    AwsError,
    zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse.ReadOnly
  ]
  def getLayerVersionPolicy(
      request: GetLayerVersionPolicyRequest
  ): IO[AwsError, zio.aws.lambda.model.GetLayerVersionPolicyResponse.ReadOnly]
  def listCodeSigningConfigs(
      request: ListCodeSigningConfigsRequest
  ): ZStream[Any, AwsError, zio.aws.lambda.model.CodeSigningConfig.ReadOnly]
  def listCodeSigningConfigsPaginated(
      request: ListCodeSigningConfigsRequest
  ): IO[AwsError, zio.aws.lambda.model.ListCodeSigningConfigsResponse.ReadOnly]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def updateCodeSigningConfig(
      request: UpdateCodeSigningConfigRequest
  ): IO[AwsError, zio.aws.lambda.model.UpdateCodeSigningConfigResponse.ReadOnly]
  def deleteAlias(request: DeleteAliasRequest): IO[AwsError, Unit]
  def getAlias(
      request: GetAliasRequest
  ): IO[AwsError, zio.aws.lambda.model.GetAliasResponse.ReadOnly]
  def createEventSourceMapping(request: CreateEventSourceMappingRequest): IO[
    AwsError,
    zio.aws.lambda.model.CreateEventSourceMappingResponse.ReadOnly
  ]
  def getLayerVersionByArn(
      request: GetLayerVersionByArnRequest
  ): IO[AwsError, zio.aws.lambda.model.GetLayerVersionByArnResponse.ReadOnly]
  def getFunctionConcurrency(
      request: GetFunctionConcurrencyRequest
  ): IO[AwsError, zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly]
  def listFunctions(
      request: ListFunctionsRequest
  ): ZStream[Any, AwsError, zio.aws.lambda.model.FunctionConfiguration.ReadOnly]
  def listFunctionsPaginated(
      request: ListFunctionsRequest
  ): IO[AwsError, zio.aws.lambda.model.ListFunctionsResponse.ReadOnly]
  def getPolicy(
      request: GetPolicyRequest
  ): IO[AwsError, zio.aws.lambda.model.GetPolicyResponse.ReadOnly]
  def listLayerVersions(
      request: ListLayerVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.lambda.model.LayerVersionsListItem.ReadOnly]
  def listLayerVersionsPaginated(
      request: ListLayerVersionsRequest
  ): IO[AwsError, zio.aws.lambda.model.ListLayerVersionsResponse.ReadOnly]
  def deleteFunctionConcurrency(
      request: DeleteFunctionConcurrencyRequest
  ): IO[AwsError, Unit]
  def createCodeSigningConfig(
      request: CreateCodeSigningConfigRequest
  ): IO[AwsError, zio.aws.lambda.model.CreateCodeSigningConfigResponse.ReadOnly]
  def publishVersion(
      request: PublishVersionRequest
  ): IO[AwsError, zio.aws.lambda.model.PublishVersionResponse.ReadOnly]
  def getAccountSettings(
      request: GetAccountSettingsRequest
  ): IO[AwsError, zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly]
  def deleteFunctionCodeSigningConfig(
      request: DeleteFunctionCodeSigningConfigRequest
  ): IO[AwsError, Unit]
  def createFunction(
      request: CreateFunctionRequest
  ): IO[AwsError, zio.aws.lambda.model.CreateFunctionResponse.ReadOnly]
  def getFunction(
      request: GetFunctionRequest
  ): IO[AwsError, zio.aws.lambda.model.GetFunctionResponse.ReadOnly]
}
object Lambda {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Lambda] = customized(
    identity
  )
  def customized(
      customization: LambdaAsyncClientBuilder => LambdaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Lambda] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: LambdaAsyncClientBuilder => LambdaAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Lambda] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = LambdaAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[LambdaAsyncClient, LambdaAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[LambdaAsyncClient, LambdaAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new LambdaImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class LambdaImpl[R](
      override val api: LambdaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Lambda
      with AwsServiceBase[R] {
    override val serviceName: String = "Lambda"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LambdaImpl[R1] = new LambdaImpl(api, newAspect, r)
    def listEventSourceMappings(
        request: ListEventSourceMappingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest,
      EventSourceMappingConfiguration,
      ListEventSourceMappingsPublisher
    ](
      "listEventSourceMappings",
      api.listEventSourceMappingsPaginator,
      _.eventSourceMappings()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lambda.model.EventSourceMappingConfiguration.wrap(item)
      )
      .provideEnvironment(r)
    def listEventSourceMappingsPaginated(
        request: ListEventSourceMappingsRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.ListEventSourceMappingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest,
      ListEventSourceMappingsResponse
    ]("listEventSourceMappings", api.listEventSourceMappings)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.ListEventSourceMappingsResponse.wrap)
      .provideEnvironment(r)
    def getLayerVersion(
        request: GetLayerVersionRequest
    ): IO[AwsError, zio.aws.lambda.model.GetLayerVersionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest,
        GetLayerVersionResponse
      ]("getLayerVersion", api.getLayerVersion)(request.buildAwsValue())
        .map(zio.aws.lambda.model.GetLayerVersionResponse.wrap)
        .provideEnvironment(r)
    def putFunctionCodeSigningConfig(
        request: PutFunctionCodeSigningConfigRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest,
      PutFunctionCodeSigningConfigResponse
    ]("putFunctionCodeSigningConfig", api.putFunctionCodeSigningConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse.wrap)
      .provideEnvironment(r)
    def updateEventSourceMapping(request: UpdateEventSourceMappingRequest): IO[
      AwsError,
      zio.aws.lambda.model.UpdateEventSourceMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest,
      UpdateEventSourceMappingResponse
    ]("updateEventSourceMapping", api.updateEventSourceMapping)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.UpdateEventSourceMappingResponse.wrap)
      .provideEnvironment(r)
    def deleteEventSourceMapping(request: DeleteEventSourceMappingRequest): IO[
      AwsError,
      zio.aws.lambda.model.DeleteEventSourceMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest,
      DeleteEventSourceMappingResponse
    ]("deleteEventSourceMapping", api.deleteEventSourceMapping)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.DeleteEventSourceMappingResponse.wrap)
      .provideEnvironment(r)
    def getFunctionEventInvokeConfig(
        request: GetFunctionEventInvokeConfigRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.GetFunctionEventInvokeConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest,
      GetFunctionEventInvokeConfigResponse
    ]("getFunctionEventInvokeConfig", api.getFunctionEventInvokeConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.GetFunctionEventInvokeConfigResponse.wrap)
      .provideEnvironment(r)
    def updateFunctionCode(
        request: UpdateFunctionCodeRequest
    ): IO[AwsError, zio.aws.lambda.model.UpdateFunctionCodeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest,
        UpdateFunctionCodeResponse
      ]("updateFunctionCode", api.updateFunctionCode)(request.buildAwsValue())
        .map(zio.aws.lambda.model.UpdateFunctionCodeResponse.wrap)
        .provideEnvironment(r)
    def addLayerVersionPermission(
        request: AddLayerVersionPermissionRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.AddLayerVersionPermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest,
      AddLayerVersionPermissionResponse
    ]("addLayerVersionPermission", api.addLayerVersionPermission)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.AddLayerVersionPermissionResponse.wrap)
      .provideEnvironment(r)
    def listFunctionsByCodeSigningConfig(
        request: ListFunctionsByCodeSigningConfigRequest
    ): ZStream[Any, AwsError, FunctionArn] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest,
      java.lang.String,
      ListFunctionsByCodeSigningConfigPublisher
    ](
      "listFunctionsByCodeSigningConfig",
      api.listFunctionsByCodeSigningConfigPaginator,
      _.functionArns()
    )(request.buildAwsValue())
      .map(item => zio.aws.lambda.model.primitives.FunctionArn(item))
      .provideEnvironment(r)
    def listFunctionsByCodeSigningConfigPaginated(
        request: ListFunctionsByCodeSigningConfigRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest,
      ListFunctionsByCodeSigningConfigResponse
    ]("listFunctionsByCodeSigningConfig", api.listFunctionsByCodeSigningConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse.wrap)
      .provideEnvironment(r)
    def invoke(
        request: InvokeRequest
    ): IO[AwsError, zio.aws.lambda.model.InvokeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.InvokeRequest,
        InvokeResponse
      ]("invoke", api.invoke)(request.buildAwsValue())
        .map(zio.aws.lambda.model.InvokeResponse.wrap)
        .provideEnvironment(r)
    def listTags(
        request: ListTagsRequest
    ): IO[AwsError, zio.aws.lambda.model.ListTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.ListTagsRequest,
        ListTagsResponse
      ]("listTags", api.listTags)(request.buildAwsValue())
        .map(zio.aws.lambda.model.ListTagsResponse.wrap)
        .provideEnvironment(r)
    def publishLayerVersion(
        request: PublishLayerVersionRequest
    ): IO[AwsError, zio.aws.lambda.model.PublishLayerVersionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest,
        PublishLayerVersionResponse
      ]("publishLayerVersion", api.publishLayerVersion)(request.buildAwsValue())
        .map(zio.aws.lambda.model.PublishLayerVersionResponse.wrap)
        .provideEnvironment(r)
    def getCodeSigningConfig(request: GetCodeSigningConfigRequest): IO[
      AwsError,
      zio.aws.lambda.model.GetCodeSigningConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest,
      GetCodeSigningConfigResponse
    ]("getCodeSigningConfig", api.getCodeSigningConfig)(request.buildAwsValue())
      .map(zio.aws.lambda.model.GetCodeSigningConfigResponse.wrap)
      .provideEnvironment(r)
    def listFunctionEventInvokeConfigs(
        request: ListFunctionEventInvokeConfigsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest,
      FunctionEventInvokeConfig,
      ListFunctionEventInvokeConfigsPublisher
    ](
      "listFunctionEventInvokeConfigs",
      api.listFunctionEventInvokeConfigsPaginator,
      _.functionEventInvokeConfigs()
    )(request.buildAwsValue())
      .map(item => zio.aws.lambda.model.FunctionEventInvokeConfig.wrap(item))
      .provideEnvironment(r)
    def listFunctionEventInvokeConfigsPaginated(
        request: ListFunctionEventInvokeConfigsRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest,
      ListFunctionEventInvokeConfigsResponse
    ]("listFunctionEventInvokeConfigs", api.listFunctionEventInvokeConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse.wrap)
      .provideEnvironment(r)
    def listLayers(
        request: ListLayersRequest
    ): ZStream[Any, AwsError, zio.aws.lambda.model.LayersListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.lambda.model.ListLayersRequest,
        LayersListItem,
        ListLayersPublisher
      ]("listLayers", api.listLayersPaginator, _.layers())(
        request.buildAwsValue()
      ).map(item => zio.aws.lambda.model.LayersListItem.wrap(item))
        .provideEnvironment(r)
    def listLayersPaginated(
        request: ListLayersRequest
    ): IO[AwsError, zio.aws.lambda.model.ListLayersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.ListLayersRequest,
        ListLayersResponse
      ]("listLayers", api.listLayers)(request.buildAwsValue())
        .map(zio.aws.lambda.model.ListLayersResponse.wrap)
        .provideEnvironment(r)
    def getEventSourceMapping(
        request: GetEventSourceMappingRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest,
      GetEventSourceMappingResponse
    ]("getEventSourceMapping", api.getEventSourceMapping)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.GetEventSourceMappingResponse.wrap)
      .provideEnvironment(r)
    def removeLayerVersionPermission(
        request: RemoveLayerVersionPermissionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest,
      RemoveLayerVersionPermissionResponse
    ]("removeLayerVersionPermission", api.removeLayerVersionPermission)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateFunctionEventInvokeConfig(
        request: UpdateFunctionEventInvokeConfigRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.UpdateFunctionEventInvokeConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest,
      UpdateFunctionEventInvokeConfigResponse
    ]("updateFunctionEventInvokeConfig", api.updateFunctionEventInvokeConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.UpdateFunctionEventInvokeConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteFunctionEventInvokeConfig(
        request: DeleteFunctionEventInvokeConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest,
      DeleteFunctionEventInvokeConfigResponse
    ]("deleteFunctionEventInvokeConfig", api.deleteFunctionEventInvokeConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteCodeSigningConfig(request: DeleteCodeSigningConfigRequest): IO[
      AwsError,
      zio.aws.lambda.model.DeleteCodeSigningConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest,
      DeleteCodeSigningConfigResponse
    ]("deleteCodeSigningConfig", api.deleteCodeSigningConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.DeleteCodeSigningConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteFunction(request: DeleteFunctionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest,
        DeleteFunctionResponse
      ]("deleteFunction", api.deleteFunction)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def putProvisionedConcurrencyConfig(
        request: PutProvisionedConcurrencyConfigRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.PutProvisionedConcurrencyConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest,
      PutProvisionedConcurrencyConfigResponse
    ]("putProvisionedConcurrencyConfig", api.putProvisionedConcurrencyConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.PutProvisionedConcurrencyConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteProvisionedConcurrencyConfig(
        request: DeleteProvisionedConcurrencyConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest,
      DeleteProvisionedConcurrencyConfigResponse
    ](
      "deleteProvisionedConcurrencyConfig",
      api.deleteProvisionedConcurrencyConfig
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listAliases(request: ListAliasesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lambda.model.AliasConfiguration.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.lambda.model.ListAliasesRequest,
      AliasConfiguration,
      ListAliasesPublisher
    ]("listAliases", api.listAliasesPaginator, _.aliases())(
      request.buildAwsValue()
    ).map(item => zio.aws.lambda.model.AliasConfiguration.wrap(item))
      .provideEnvironment(r)
    def listAliasesPaginated(
        request: ListAliasesRequest
    ): IO[AwsError, zio.aws.lambda.model.ListAliasesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.ListAliasesRequest,
        ListAliasesResponse
      ]("listAliases", api.listAliases)(request.buildAwsValue())
        .map(zio.aws.lambda.model.ListAliasesResponse.wrap)
        .provideEnvironment(r)
    def deleteLayerVersion(
        request: DeleteLayerVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.DeleteLayerVersionRequest,
      DeleteLayerVersionResponse
    ]("deleteLayerVersion", api.deleteLayerVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listProvisionedConcurrencyConfigs(
        request: ListProvisionedConcurrencyConfigsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest,
      ProvisionedConcurrencyConfigListItem,
      ListProvisionedConcurrencyConfigsPublisher
    ](
      "listProvisionedConcurrencyConfigs",
      api.listProvisionedConcurrencyConfigsPaginator,
      _.provisionedConcurrencyConfigs()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.wrap(item)
      )
      .provideEnvironment(r)
    def listProvisionedConcurrencyConfigsPaginated(
        request: ListProvisionedConcurrencyConfigsRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest,
      ListProvisionedConcurrencyConfigsResponse
    ](
      "listProvisionedConcurrencyConfigs",
      api.listProvisionedConcurrencyConfigs
    )(request.buildAwsValue())
      .map(zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse.wrap)
      .provideEnvironment(r)
    def putFunctionConcurrency(request: PutFunctionConcurrencyRequest): IO[
      AwsError,
      zio.aws.lambda.model.PutFunctionConcurrencyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest,
      PutFunctionConcurrencyResponse
    ]("putFunctionConcurrency", api.putFunctionConcurrency)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.PutFunctionConcurrencyResponse.wrap)
      .provideEnvironment(r)
    def addPermission(
        request: AddPermissionRequest
    ): IO[AwsError, zio.aws.lambda.model.AddPermissionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.AddPermissionRequest,
        AddPermissionResponse
      ]("addPermission", api.addPermission)(request.buildAwsValue())
        .map(zio.aws.lambda.model.AddPermissionResponse.wrap)
        .provideEnvironment(r)
    def getProvisionedConcurrencyConfig(
        request: GetProvisionedConcurrencyConfigRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.GetProvisionedConcurrencyConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest,
      GetProvisionedConcurrencyConfigResponse
    ]("getProvisionedConcurrencyConfig", api.getProvisionedConcurrencyConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.GetProvisionedConcurrencyConfigResponse.wrap)
      .provideEnvironment(r)
    def updateFunctionConfiguration(
        request: UpdateFunctionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.UpdateFunctionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest,
      UpdateFunctionConfigurationResponse
    ]("updateFunctionConfiguration", api.updateFunctionConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.UpdateFunctionConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listVersionsByFunction(request: ListVersionsByFunctionRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lambda.model.FunctionConfiguration.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest,
      FunctionConfiguration,
      ListVersionsByFunctionPublisher
    ](
      "listVersionsByFunction",
      api.listVersionsByFunctionPaginator,
      _.versions()
    )(request.buildAwsValue())
      .map(item => zio.aws.lambda.model.FunctionConfiguration.wrap(item))
      .provideEnvironment(r)
    def listVersionsByFunctionPaginated(
        request: ListVersionsByFunctionRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.ListVersionsByFunctionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest,
      ListVersionsByFunctionResponse
    ]("listVersionsByFunction", api.listVersionsByFunction)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.ListVersionsByFunctionResponse.wrap)
      .provideEnvironment(r)
    def updateAlias(
        request: UpdateAliasRequest
    ): IO[AwsError, zio.aws.lambda.model.UpdateAliasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.UpdateAliasRequest,
        UpdateAliasResponse
      ]("updateAlias", api.updateAlias)(request.buildAwsValue())
        .map(zio.aws.lambda.model.UpdateAliasResponse.wrap)
        .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createAlias(
        request: CreateAliasRequest
    ): IO[AwsError, zio.aws.lambda.model.CreateAliasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.CreateAliasRequest,
        CreateAliasResponse
      ]("createAlias", api.createAlias)(request.buildAwsValue())
        .map(zio.aws.lambda.model.CreateAliasResponse.wrap)
        .provideEnvironment(r)
    def putFunctionEventInvokeConfig(
        request: PutFunctionEventInvokeConfigRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigRequest,
      PutFunctionEventInvokeConfigResponse
    ]("putFunctionEventInvokeConfig", api.putFunctionEventInvokeConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse.wrap)
      .provideEnvironment(r)
    def removePermission(request: RemovePermissionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.RemovePermissionRequest,
        RemovePermissionResponse
      ]("removePermission", api.removePermission)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getFunctionConfiguration(request: GetFunctionConfigurationRequest): IO[
      AwsError,
      zio.aws.lambda.model.GetFunctionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest,
      GetFunctionConfigurationResponse
    ]("getFunctionConfiguration", api.getFunctionConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.GetFunctionConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getFunctionCodeSigningConfig(
        request: GetFunctionCodeSigningConfigRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest,
      GetFunctionCodeSigningConfigResponse
    ]("getFunctionCodeSigningConfig", api.getFunctionCodeSigningConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse.wrap)
      .provideEnvironment(r)
    def getLayerVersionPolicy(request: GetLayerVersionPolicyRequest): IO[
      AwsError,
      zio.aws.lambda.model.GetLayerVersionPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest,
      GetLayerVersionPolicyResponse
    ]("getLayerVersionPolicy", api.getLayerVersionPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.GetLayerVersionPolicyResponse.wrap)
      .provideEnvironment(r)
    def listCodeSigningConfigs(request: ListCodeSigningConfigsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lambda.model.CodeSigningConfig.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest,
      CodeSigningConfig,
      ListCodeSigningConfigsPublisher
    ](
      "listCodeSigningConfigs",
      api.listCodeSigningConfigsPaginator,
      _.codeSigningConfigs()
    )(request.buildAwsValue())
      .map(item => zio.aws.lambda.model.CodeSigningConfig.wrap(item))
      .provideEnvironment(r)
    def listCodeSigningConfigsPaginated(
        request: ListCodeSigningConfigsRequest
    ): IO[
      AwsError,
      zio.aws.lambda.model.ListCodeSigningConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest,
      ListCodeSigningConfigsResponse
    ]("listCodeSigningConfigs", api.listCodeSigningConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.ListCodeSigningConfigsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def updateCodeSigningConfig(request: UpdateCodeSigningConfigRequest): IO[
      AwsError,
      zio.aws.lambda.model.UpdateCodeSigningConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest,
      UpdateCodeSigningConfigResponse
    ]("updateCodeSigningConfig", api.updateCodeSigningConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.UpdateCodeSigningConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteAlias(request: DeleteAliasRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.DeleteAliasRequest,
        DeleteAliasResponse
      ]("deleteAlias", api.deleteAlias)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getAlias(
        request: GetAliasRequest
    ): IO[AwsError, zio.aws.lambda.model.GetAliasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.GetAliasRequest,
        GetAliasResponse
      ]("getAlias", api.getAlias)(request.buildAwsValue())
        .map(zio.aws.lambda.model.GetAliasResponse.wrap)
        .provideEnvironment(r)
    def createEventSourceMapping(request: CreateEventSourceMappingRequest): IO[
      AwsError,
      zio.aws.lambda.model.CreateEventSourceMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest,
      CreateEventSourceMappingResponse
    ]("createEventSourceMapping", api.createEventSourceMapping)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.CreateEventSourceMappingResponse.wrap)
      .provideEnvironment(r)
    def getLayerVersionByArn(request: GetLayerVersionByArnRequest): IO[
      AwsError,
      zio.aws.lambda.model.GetLayerVersionByArnResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest,
      GetLayerVersionByArnResponse
    ]("getLayerVersionByArn", api.getLayerVersionByArn)(request.buildAwsValue())
      .map(zio.aws.lambda.model.GetLayerVersionByArnResponse.wrap)
      .provideEnvironment(r)
    def getFunctionConcurrency(request: GetFunctionConcurrencyRequest): IO[
      AwsError,
      zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest,
      GetFunctionConcurrencyResponse
    ]("getFunctionConcurrency", api.getFunctionConcurrency)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.GetFunctionConcurrencyResponse.wrap)
      .provideEnvironment(r)
    def listFunctions(request: ListFunctionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lambda.model.FunctionConfiguration.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.lambda.model.ListFunctionsRequest,
      FunctionConfiguration,
      ListFunctionsPublisher
    ]("listFunctions", api.listFunctionsPaginator, _.functions())(
      request.buildAwsValue()
    ).map(item => zio.aws.lambda.model.FunctionConfiguration.wrap(item))
      .provideEnvironment(r)
    def listFunctionsPaginated(
        request: ListFunctionsRequest
    ): IO[AwsError, zio.aws.lambda.model.ListFunctionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.ListFunctionsRequest,
        ListFunctionsResponse
      ]("listFunctions", api.listFunctions)(request.buildAwsValue())
        .map(zio.aws.lambda.model.ListFunctionsResponse.wrap)
        .provideEnvironment(r)
    def getPolicy(
        request: GetPolicyRequest
    ): IO[AwsError, zio.aws.lambda.model.GetPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.GetPolicyRequest,
        GetPolicyResponse
      ]("getPolicy", api.getPolicy)(request.buildAwsValue())
        .map(zio.aws.lambda.model.GetPolicyResponse.wrap)
        .provideEnvironment(r)
    def listLayerVersions(request: ListLayerVersionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lambda.model.LayerVersionsListItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest,
      LayerVersionsListItem,
      ListLayerVersionsPublisher
    ]("listLayerVersions", api.listLayerVersionsPaginator, _.layerVersions())(
      request.buildAwsValue()
    ).map(item => zio.aws.lambda.model.LayerVersionsListItem.wrap(item))
      .provideEnvironment(r)
    def listLayerVersionsPaginated(
        request: ListLayerVersionsRequest
    ): IO[AwsError, zio.aws.lambda.model.ListLayerVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest,
        ListLayerVersionsResponse
      ]("listLayerVersions", api.listLayerVersions)(request.buildAwsValue())
        .map(zio.aws.lambda.model.ListLayerVersionsResponse.wrap)
        .provideEnvironment(r)
    def deleteFunctionConcurrency(
        request: DeleteFunctionConcurrencyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest,
      DeleteFunctionConcurrencyResponse
    ]("deleteFunctionConcurrency", api.deleteFunctionConcurrency)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createCodeSigningConfig(request: CreateCodeSigningConfigRequest): IO[
      AwsError,
      zio.aws.lambda.model.CreateCodeSigningConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest,
      CreateCodeSigningConfigResponse
    ]("createCodeSigningConfig", api.createCodeSigningConfig)(
      request.buildAwsValue()
    ).map(zio.aws.lambda.model.CreateCodeSigningConfigResponse.wrap)
      .provideEnvironment(r)
    def publishVersion(
        request: PublishVersionRequest
    ): IO[AwsError, zio.aws.lambda.model.PublishVersionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.PublishVersionRequest,
        PublishVersionResponse
      ]("publishVersion", api.publishVersion)(request.buildAwsValue())
        .map(zio.aws.lambda.model.PublishVersionResponse.wrap)
        .provideEnvironment(r)
    def getAccountSettings(
        request: GetAccountSettingsRequest
    ): IO[AwsError, zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest,
        GetAccountSettingsResponse
      ]("getAccountSettings", api.getAccountSettings)(request.buildAwsValue())
        .map(zio.aws.lambda.model.GetAccountSettingsResponse.wrap)
        .provideEnvironment(r)
    def deleteFunctionCodeSigningConfig(
        request: DeleteFunctionCodeSigningConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest,
      DeleteFunctionCodeSigningConfigResponse
    ]("deleteFunctionCodeSigningConfig", api.deleteFunctionCodeSigningConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createFunction(
        request: CreateFunctionRequest
    ): IO[AwsError, zio.aws.lambda.model.CreateFunctionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.CreateFunctionRequest,
        CreateFunctionResponse
      ]("createFunction", api.createFunction)(request.buildAwsValue())
        .map(zio.aws.lambda.model.CreateFunctionResponse.wrap)
        .provideEnvironment(r)
    def getFunction(
        request: GetFunctionRequest
    ): IO[AwsError, zio.aws.lambda.model.GetFunctionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lambda.model.GetFunctionRequest,
        GetFunctionResponse
      ]("getFunction", api.getFunction)(request.buildAwsValue())
        .map(zio.aws.lambda.model.GetFunctionResponse.wrap)
        .provideEnvironment(r)
  }
  def listEventSourceMappings(request: ListEventSourceMappingsRequest): ZStream[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.listEventSourceMappings(request))
  def listEventSourceMappingsPaginated(
      request: ListEventSourceMappingsRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListEventSourceMappingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventSourceMappingsPaginated(request))
  def getLayerVersion(request: GetLayerVersionRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetLayerVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLayerVersion(request))
  def putFunctionCodeSigningConfig(
      request: PutFunctionCodeSigningConfigRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.PutFunctionCodeSigningConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putFunctionCodeSigningConfig(request))
  def updateEventSourceMapping(request: UpdateEventSourceMappingRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.UpdateEventSourceMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEventSourceMapping(request))
  def deleteEventSourceMapping(request: DeleteEventSourceMappingRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.DeleteEventSourceMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEventSourceMapping(request))
  def getFunctionEventInvokeConfig(
      request: GetFunctionEventInvokeConfigRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetFunctionEventInvokeConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFunctionEventInvokeConfig(request))
  def updateFunctionCode(request: UpdateFunctionCodeRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.UpdateFunctionCodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFunctionCode(request))
  def addLayerVersionPermission(request: AddLayerVersionPermissionRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.AddLayerVersionPermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addLayerVersionPermission(request))
  def listFunctionsByCodeSigningConfig(
      request: ListFunctionsByCodeSigningConfigRequest
  ): ZStream[zio.aws.lambda.Lambda, AwsError, FunctionArn] =
    ZStream.serviceWithStream(_.listFunctionsByCodeSigningConfig(request))
  def listFunctionsByCodeSigningConfigPaginated(
      request: ListFunctionsByCodeSigningConfigRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListFunctionsByCodeSigningConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFunctionsByCodeSigningConfigPaginated(request))
  def invoke(request: InvokeRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.InvokeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.invoke(request))
  def listTags(request: ListTagsRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTags(request))
  def publishLayerVersion(request: PublishLayerVersionRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.PublishLayerVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.publishLayerVersion(request))
  def getCodeSigningConfig(request: GetCodeSigningConfigRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetCodeSigningConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCodeSigningConfig(request))
  def listFunctionEventInvokeConfigs(
      request: ListFunctionEventInvokeConfigsRequest
  ): ZStream[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listFunctionEventInvokeConfigs(request))
  def listFunctionEventInvokeConfigsPaginated(
      request: ListFunctionEventInvokeConfigsRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFunctionEventInvokeConfigsPaginated(request))
  def listLayers(request: ListLayersRequest): ZStream[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.LayersListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listLayers(request))
  def listLayersPaginated(request: ListLayersRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListLayersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLayersPaginated(request))
  def getEventSourceMapping(
      request: GetEventSourceMappingRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getEventSourceMapping(request))
  def removeLayerVersionPermission(
      request: RemoveLayerVersionPermissionRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeLayerVersionPermission(request))
  def updateFunctionEventInvokeConfig(
      request: UpdateFunctionEventInvokeConfigRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.UpdateFunctionEventInvokeConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFunctionEventInvokeConfig(request))
  def deleteFunctionEventInvokeConfig(
      request: DeleteFunctionEventInvokeConfigRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFunctionEventInvokeConfig(request))
  def deleteCodeSigningConfig(request: DeleteCodeSigningConfigRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.DeleteCodeSigningConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCodeSigningConfig(request))
  def deleteFunction(
      request: DeleteFunctionRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFunction(request))
  def putProvisionedConcurrencyConfig(
      request: PutProvisionedConcurrencyConfigRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.PutProvisionedConcurrencyConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putProvisionedConcurrencyConfig(request))
  def deleteProvisionedConcurrencyConfig(
      request: DeleteProvisionedConcurrencyConfigRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteProvisionedConcurrencyConfig(request))
  def listAliases(request: ListAliasesRequest): ZStream[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.AliasConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.listAliases(request))
  def listAliasesPaginated(request: ListAliasesRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAliasesPaginated(request))
  def deleteLayerVersion(
      request: DeleteLayerVersionRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteLayerVersion(request))
  def listProvisionedConcurrencyConfigs(
      request: ListProvisionedConcurrencyConfigsRequest
  ): ZStream[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listProvisionedConcurrencyConfigs(request))
  def listProvisionedConcurrencyConfigsPaginated(
      request: ListProvisionedConcurrencyConfigsRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListProvisionedConcurrencyConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProvisionedConcurrencyConfigsPaginated(request))
  def putFunctionConcurrency(request: PutFunctionConcurrencyRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.PutFunctionConcurrencyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putFunctionConcurrency(request))
  def addPermission(request: AddPermissionRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.AddPermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addPermission(request))
  def getProvisionedConcurrencyConfig(
      request: GetProvisionedConcurrencyConfigRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetProvisionedConcurrencyConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProvisionedConcurrencyConfig(request))
  def updateFunctionConfiguration(
      request: UpdateFunctionConfigurationRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.UpdateFunctionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFunctionConfiguration(request))
  def listVersionsByFunction(request: ListVersionsByFunctionRequest): ZStream[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.FunctionConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.listVersionsByFunction(request))
  def listVersionsByFunctionPaginated(
      request: ListVersionsByFunctionRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListVersionsByFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVersionsByFunctionPaginated(request))
  def updateAlias(request: UpdateAliasRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.UpdateAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAlias(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def createAlias(request: CreateAliasRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.CreateAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAlias(request))
  def putFunctionEventInvokeConfig(
      request: PutFunctionEventInvokeConfigRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.PutFunctionEventInvokeConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putFunctionEventInvokeConfig(request))
  def removePermission(
      request: RemovePermissionRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removePermission(request))
  def getFunctionConfiguration(request: GetFunctionConfigurationRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetFunctionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFunctionConfiguration(request))
  def getFunctionCodeSigningConfig(
      request: GetFunctionCodeSigningConfigRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFunctionCodeSigningConfig(request))
  def getLayerVersionPolicy(request: GetLayerVersionPolicyRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetLayerVersionPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLayerVersionPolicy(request))
  def listCodeSigningConfigs(request: ListCodeSigningConfigsRequest): ZStream[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.CodeSigningConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listCodeSigningConfigs(request))
  def listCodeSigningConfigsPaginated(
      request: ListCodeSigningConfigsRequest
  ): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListCodeSigningConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCodeSigningConfigsPaginated(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def updateCodeSigningConfig(request: UpdateCodeSigningConfigRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.UpdateCodeSigningConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCodeSigningConfig(request))
  def deleteAlias(
      request: DeleteAliasRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAlias(request))
  def getAlias(request: GetAliasRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAlias(request))
  def createEventSourceMapping(request: CreateEventSourceMappingRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.CreateEventSourceMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEventSourceMapping(request))
  def getLayerVersionByArn(request: GetLayerVersionByArnRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetLayerVersionByArnResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLayerVersionByArn(request))
  def getFunctionConcurrency(request: GetFunctionConcurrencyRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetFunctionConcurrencyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFunctionConcurrency(request))
  def listFunctions(request: ListFunctionsRequest): ZStream[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.FunctionConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.listFunctions(request))
  def listFunctionsPaginated(request: ListFunctionsRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListFunctionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFunctionsPaginated(request))
  def getPolicy(request: GetPolicyRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPolicy(request))
  def listLayerVersions(request: ListLayerVersionsRequest): ZStream[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.LayerVersionsListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listLayerVersions(request))
  def listLayerVersionsPaginated(request: ListLayerVersionsRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.ListLayerVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLayerVersionsPaginated(request))
  def deleteFunctionConcurrency(
      request: DeleteFunctionConcurrencyRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFunctionConcurrency(request))
  def createCodeSigningConfig(request: CreateCodeSigningConfigRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.CreateCodeSigningConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCodeSigningConfig(request))
  def publishVersion(request: PublishVersionRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.PublishVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.publishVersion(request))
  def getAccountSettings(request: GetAccountSettingsRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetAccountSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountSettings(request))
  def deleteFunctionCodeSigningConfig(
      request: DeleteFunctionCodeSigningConfigRequest
  ): ZIO[zio.aws.lambda.Lambda, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFunctionCodeSigningConfig(request))
  def createFunction(request: CreateFunctionRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.CreateFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFunction(request))
  def getFunction(request: GetFunctionRequest): ZIO[
    zio.aws.lambda.Lambda,
    AwsError,
    zio.aws.lambda.model.GetFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFunction(request))
}
